/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.nio.ByteBuffer;
import java.util.function.Predicate;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.pagememory.datapage.PageMemoryTraversal;
import org.apache.ignite3.internal.pagememory.io.DataPagePayload;
import org.apache.ignite3.internal.pagememory.util.PageIdUtils;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.apache.ignite3.internal.pagememory.util.PartitionlessLinks;
import org.apache.ignite3.internal.schema.BinaryRowImpl;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.storage.pagememory.mv.HybridTimestamps;
import org.apache.ignite3.internal.storage.pagememory.mv.ReadRowVersionValue;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersion;
import org.jetbrains.annotations.Nullable;

class ReadRowVersion
implements PageMemoryTraversal<Predicate<HybridTimestamp>> {
    private final int partitionId;
    private RowVersion result;
    private boolean readingFirstSlot = true;
    private long firstFragmentLink;
    @Nullable
    private HybridTimestamp timestamp;
    private long nextLink;
    private int schemaVersion;
    private boolean isArchived;
    private final ReadRowVersionValue readRowVersionValue = new ReadRowVersionValue();

    ReadRowVersion(int partitionId) {
        this.partitionId = partitionId;
    }

    @Override
    public long consumePagePayload(long link, long pageAddr, DataPagePayload payload, Predicate<HybridTimestamp> loadValue) {
        if (this.readingFirstSlot) {
            this.readingFirstSlot = false;
            return this.readFullOrInitiateReadFragmented(link, pageAddr, payload, loadValue);
        }
        return this.readRowVersionValue.consumePagePayload(link, pageAddr, payload, null);
    }

    private long readFullOrInitiateReadFragmented(long link, long pageAddr, DataPagePayload payload, Predicate<HybridTimestamp> loadValue) {
        this.firstFragmentLink = link;
        this.timestamp = HybridTimestamps.readTimestamp(pageAddr, payload.offset() + 1);
        this.nextLink = PartitionlessLinks.readPartitionless(this.partitionId, pageAddr, payload.offset() + 9);
        this.schemaVersion = Short.toUnsignedInt(PageUtils.getShort(pageAddr, payload.offset() + 19));
        boolean hasArchivedField = this.schemaVersion == 0 && payload.payloadSize() == 22;
        boolean bl = this.isArchived = hasArchivedField && PageUtils.getByte(pageAddr, payload.offset() + 21) == 1;
        if (!loadValue.test(this.timestamp)) {
            int valueSize = PageUtils.getInt(pageAddr, payload.offset() + 15);
            this.result = new RowVersion(PageIdUtils.partitionIdFromLink(link), this.firstFragmentLink, this.timestamp, this.nextLink, valueSize, this.isArchived);
            return 0L;
        }
        return this.readRowVersionValue.consumePagePayload(link, pageAddr, payload, null);
    }

    @Override
    public void finish() {
        if (this.result != null) {
            return;
        }
        this.readRowVersionValue.finish();
        byte[] valueBytes = this.readRowVersionValue.result();
        BinaryRowImpl row = valueBytes.length == 0 ? null : new BinaryRowImpl(this.schemaVersion, ByteBuffer.wrap(valueBytes).order(BinaryTuple.ORDER));
        this.result = new RowVersion(PageIdUtils.partitionIdFromLink(this.firstFragmentLink), this.firstFragmentLink, this.timestamp, this.nextLink, row, this.isArchived);
    }

    RowVersion result() {
        return this.result;
    }

    void reset() {
        this.result = null;
        this.readingFirstSlot = true;
        this.readRowVersionValue.reset();
    }
}

