/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.engine.StorageTableDescriptor;
import org.apache.ignite3.internal.storage.index.StorageIndexDescriptorSupplier;
import org.apache.ignite3.internal.storage.pagememory.AbstractPageMemoryTableStorage;
import org.apache.ignite3.internal.storage.pagememory.VolatilePageMemoryDataRegion;
import org.apache.ignite3.internal.storage.pagememory.VolatilePageMemoryStorageEngine;
import org.apache.ignite3.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite3.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.UpdateLogTree;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChainTree;
import org.apache.ignite3.internal.storage.pagememory.mv.VolatilePageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.gc.GcQueue;
import org.apache.ignite3.internal.util.CompletableFutures;

public class VolatilePageMemoryTableStorage
extends AbstractPageMemoryTableStorage<VolatilePageMemoryMvPartitionStorage> {
    private final VolatilePageMemoryStorageEngine engine;
    private final VolatilePageMemoryDataRegion dataRegion;
    private final ExecutorService destructionExecutor;
    private final FailureProcessor failureProcessor;

    VolatilePageMemoryTableStorage(StorageTableDescriptor tableDescriptor, StorageIndexDescriptorSupplier indexDescriptorSupplier, VolatilePageMemoryStorageEngine engine, VolatilePageMemoryDataRegion dataRegion, ExecutorService destructionExecutor, FailureProcessor failureProcessor) {
        super(tableDescriptor, indexDescriptorSupplier);
        this.engine = engine;
        this.dataRegion = dataRegion;
        this.destructionExecutor = destructionExecutor;
        this.failureProcessor = failureProcessor;
    }

    public VolatilePageMemoryDataRegion dataRegion() {
        return this.dataRegion;
    }

    @Override
    public VolatilePageMemoryStorageEngine engine() {
        return this.engine;
    }

    @Override
    public VolatilePageMemoryMvPartitionStorage createMvPartitionStorage(int partitionId) throws StorageException {
        VersionChainTree versionChainTree = this.createVersionChainTree(partitionId);
        IndexMetaTree indexMetaTree = this.createIndexMetaTree(partitionId);
        GcQueue gcQueue = this.createGarbageCollectionTree(partitionId);
        UpdateLogTree updateLogTree = this.createUpdateLogTree(partitionId);
        return new VolatilePageMemoryMvPartitionStorage(this, partitionId, versionChainTree, indexMetaTree, gcQueue, this.destructionExecutor, updateLogTree, this.failureProcessor);
    }

    private IndexMetaTree createIndexMetaTree(int partitionId) {
        try {
            long metaPageId = this.dataRegion.pageMemory().allocatePage(this.dataRegion.reuseList(), this.getTableId(), partitionId, (byte)2);
            return new IndexMetaTree(this.getTableId(), Integer.toString(this.getTableId()), partitionId, this.dataRegion.pageMemory(), this.engine.generateGlobalRemoveId(), metaPageId, this.dataRegion.reuseList(), true);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException(e);
        }
    }

    private GcQueue createGarbageCollectionTree(int partitionId) {
        try {
            long metaPageId = this.dataRegion.pageMemory().allocatePage(this.dataRegion().reuseList(), this.getTableId(), partitionId, (byte)2);
            return new GcQueue(this.getTableId(), Integer.toString(this.getTableId()), partitionId, this.dataRegion.pageMemory(), this.engine.generateGlobalRemoveId(), metaPageId, this.dataRegion.reuseList(), true);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException(e);
        }
    }

    private UpdateLogTree createUpdateLogTree(int partitionId) {
        try {
            long metaPageId = this.dataRegion.pageMemory().allocatePage(this.dataRegion().reuseList(), this.getTableId(), partitionId, (byte)2);
            return new UpdateLogTree(this.getTableId(), Integer.toString(this.getTableId()), partitionId, this.dataRegion.pageMemory(), new AtomicLong(), metaPageId, this.dataRegion.reuseList(), true);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public boolean isVolatile() {
        return true;
    }

    @Override
    protected void finishDestruction() {
    }

    private VersionChainTree createVersionChainTree(int partId) throws StorageException {
        try {
            long metaPageId = this.dataRegion.pageMemory().allocatePage(this.dataRegion().reuseList(), this.getTableId(), partId, (byte)2);
            return new VersionChainTree(this.getTableId(), Integer.toString(this.getTableId()), partId, this.dataRegion.pageMemory(), this.engine.generateGlobalRemoveId(), metaPageId, this.dataRegion.reuseList(), true);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error creating TableTree: [tableId={}, partitionId={}]", (Throwable)e, this.getTableId(), partId);
        }
    }

    @Override
    CompletableFuture<Void> clearStorageAndUpdateDataStructures(AbstractPageMemoryMvPartitionStorage mvPartitionStorage) {
        VolatilePageMemoryMvPartitionStorage volatilePartitionStorage = (VolatilePageMemoryMvPartitionStorage)mvPartitionStorage;
        volatilePartitionStorage.destroyStructures().whenComplete((res, ex) -> {
            if (ex != null) {
                String errorMessage = String.format("Could not destroy structures: [tableId=%s, partitionId=%s]", this.getTableId(), volatilePartitionStorage.partitionId());
                this.failureProcessor.process(new FailureContext((Throwable)ex, errorMessage));
            }
        });
        int partitionId = mvPartitionStorage.partitionId();
        volatilePartitionStorage.updateDataStructures(this.createVersionChainTree(partitionId), this.createIndexMetaTree(partitionId), this.createGarbageCollectionTree(partitionId), this.createUpdateLogTree(partitionId));
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    CompletableFuture<Void> destroyMvPartitionStorage(AbstractPageMemoryMvPartitionStorage mvPartitionStorage) {
        VolatilePageMemoryMvPartitionStorage volatilePartitionStorage = (VolatilePageMemoryMvPartitionStorage)mvPartitionStorage;
        boolean transitioned = volatilePartitionStorage.transitionToDestroyedState();
        if (!transitioned) {
            return CompletableFutures.nullCompletedFuture();
        }
        return volatilePartitionStorage.destroyStructures().whenComplete((v, e) -> volatilePartitionStorage.closeResources());
    }
}

