/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.configurations.StorageConfiguration;
import org.apache.ignite3.internal.storage.configurations.StorageProfileView;
import org.apache.ignite3.internal.storage.configurations.StorageView;
import org.apache.ignite3.internal.storage.engine.StorageEngine;
import org.apache.ignite3.internal.storage.secondary.SecondaryStorageEngine;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.jetbrains.annotations.Nullable;

public class DataStorageManager
implements IgniteComponent {
    private final Map<String, StorageEngine> engines;
    private Map<String, String> profilesToEngines;
    private final StorageConfiguration storageConfiguration;
    private final Map<String, SecondaryStorageEngine> secondaryEngines;
    private final LicenseFeatureChecker licenseFeatureChecker;

    public DataStorageManager(Map<String, StorageEngine> engines, Map<String, SecondaryStorageEngine> secondaryEngines, StorageConfiguration storageConfiguration, LicenseFeatureChecker licenseFeatureChecker) {
        assert (!engines.isEmpty());
        this.engines = engines;
        this.secondaryEngines = secondaryEngines;
        this.storageConfiguration = storageConfiguration;
        this.licenseFeatureChecker = licenseFeatureChecker;
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) throws StorageException {
        this.engines.values().forEach(StorageEngine::start);
        this.secondaryEngines.values().forEach(SecondaryStorageEngine::start);
        this.profilesToEngines = ((StorageView)this.storageConfiguration.value()).profiles().stream().collect(Collectors.toMap(StorageProfileView::name, StorageProfileView::engine));
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        try {
            IgniteUtils.closeAll(Stream.concat(this.secondaryEngines.values().stream().map(engine -> engine::stop), this.engines.values().stream().map(engine -> engine::stop)));
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    public void checkLoadedStorageEnginesForLicense() {
        this.engines.forEach((name, engine) -> {
            LicenseFeature licenseFeature;
            if (engine.hasConfiguredStorageProfiles() && (licenseFeature = engine.licenseFeature()) != null) {
                this.licenseFeatureChecker.checkFeature(licenseFeature);
            }
        });
    }

    @Nullable
    public StorageEngine engineByStorageProfile(@Nullable String storageProfile) {
        String engine;
        if (storageProfile == null) {
            storageProfile = "default";
        }
        if ((engine = this.profilesToEngines.get(storageProfile)) == null) {
            return null;
        }
        return this.engines.get(engine);
    }

    @Nullable
    public SecondaryStorageEngine secondaryEngineByStorageProfile(@Nullable String storageProfile) {
        if (storageProfile == null) {
            return null;
        }
        String engineName = this.profilesToEngines.get(storageProfile);
        if (engineName == null) {
            return null;
        }
        SecondaryStorageEngine engine = this.secondaryEngines.get(engineName);
        this.checkSecondaryStorageEngineLicense(engine);
        return engine;
    }

    public Collection<StorageEngine> allStorageEngines() {
        return List.copyOf(this.engines.values());
    }

    public String toString() {
        return S.toString(DataStorageManager.class, this);
    }

    private void checkSecondaryStorageEngineLicense(@Nullable SecondaryStorageEngine engine) {
        if (engine == null) {
            return;
        }
        this.licenseFeatureChecker.checkFeature(LicenseFeature.SECONDARY_STORAGE);
        LicenseFeature feature = engine.licenseFeature();
        if (feature != null) {
            this.licenseFeatureChecker.checkFeature(feature);
        }
    }
}

