/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.statistic;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite3.internal.catalog.CatalogService;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.events.CatalogEvent;
import org.apache.ignite3.internal.catalog.events.CreateTableEventParameters;
import org.apache.ignite3.internal.catalog.events.DropTableEventParameters;
import org.apache.ignite3.internal.event.EventListener;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.lowwatermark.LowWatermark;
import org.apache.ignite3.internal.lowwatermark.event.ChangeLowWatermarkEventParameters;
import org.apache.ignite3.internal.lowwatermark.event.LowWatermarkEvent;
import org.apache.ignite3.internal.sql.engine.statistic.SqlStatisticManager;
import org.apache.ignite3.internal.table.LongPriorityQueue;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.internal.table.distributed.TableManager;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.FastTimestamps;
import org.jetbrains.annotations.TestOnly;

public class SqlStatisticManagerImpl
implements SqlStatisticManager {
    private static final IgniteLogger LOG = Loggers.forClass(SqlStatisticManagerImpl.class);
    static final long DEFAULT_TABLE_SIZE = 1L;
    private static final ActualSize DEFAULT_VALUE = new ActualSize(1L, 0L);
    private final EventListener<ChangeLowWatermarkEventParameters> lwmListener = EventListener.fromConsumer(this::onLwmChanged);
    private final EventListener<DropTableEventParameters> dropTableEventListener = EventListener.fromConsumer(this::onTableDrop);
    private final EventListener<CreateTableEventParameters> createTableEventListener = EventListener.fromConsumer(this::onTableCreate);
    private final AtomicReference<CompletableFuture<Void>> latestUpdateFut = new AtomicReference(CompletableFutures.nullCompletedFuture());
    private final LongPriorityQueue<DestroyTableEvent> destructionEventsQueue = new LongPriorityQueue<DestroyTableEvent>(DestroyTableEvent::catalogVersion);
    private final TableManager tableManager;
    private final CatalogService catalogService;
    private final LowWatermark lowWatermark;
    private final ConcurrentMap<Integer, ActualSize> tableSizeMap = new ConcurrentHashMap<Integer, ActualSize>();
    private volatile long thresholdTimeToPostponeUpdateMs = TimeUnit.MINUTES.toMillis(1L);

    public SqlStatisticManagerImpl(TableManager tableManager, CatalogService catalogService, LowWatermark lowWatermark) {
        this.tableManager = tableManager;
        this.catalogService = catalogService;
        this.lowWatermark = lowWatermark;
    }

    @Override
    public long tableSize(int tableId) {
        this.updateTableSizeStatistics(tableId, false);
        return this.tableSizeMap.getOrDefault(tableId, DEFAULT_VALUE).getSize();
    }

    private void updateTableSizeStatistics(int tableId, boolean force) {
        TableViewInternal tableView = this.tableManager.cachedTable(tableId);
        if (tableView == null) {
            LOG.debug("There is no table to update statistics [id={}].", tableId);
            return;
        }
        ActualSize tableSize = (ActualSize)this.tableSizeMap.get(tableId);
        if (tableSize == null) {
            return;
        }
        long currTimestamp = FastTimestamps.coarseCurrentTimeMillis();
        long lastUpdateTime = tableSize.getTimestamp();
        if (force || lastUpdateTime <= currTimestamp - this.thresholdTimeToPostponeUpdateMs) {
            if (!force && !this.tableSizeMap.replace(tableId, tableSize, new ActualSize(tableSize.getSize(), currTimestamp - 1L))) {
                return;
            }
            CompletionStage updateResult = ((CompletableFuture)tableView.internalTable().estimatedSize().thenAccept(size -> this.tableSizeMap.computeIfPresent(tableId, (k, v) -> {
                if (v.timestamp >= currTimestamp) {
                    return v;
                }
                return new ActualSize(Math.max(size, 1L), currTimestamp);
            }))).exceptionally(e -> {
                LOG.info("Can't calculate size for table [id={}].", (Throwable)e, (Object)tableId);
                return null;
            });
            this.latestUpdateFut.updateAndGet(arg_0 -> SqlStatisticManagerImpl.lambda$updateTableSizeStatistics$4((CompletableFuture)updateResult, arg_0));
        }
    }

    @Override
    public void start() {
        this.catalogService.listen(CatalogEvent.TABLE_CREATE, this.createTableEventListener);
        this.catalogService.listen(CatalogEvent.TABLE_DROP, this.dropTableEventListener);
        this.lowWatermark.listen(LowWatermarkEvent.LOW_WATERMARK_CHANGED, this.lwmListener);
        int earliestVersion = this.catalogService.earliestCatalogVersion();
        int latestVersion = this.catalogService.latestCatalogVersion();
        for (int version = earliestVersion; version <= latestVersion; ++version) {
            Collection<CatalogTableDescriptor> tables = this.catalogService.catalog(version).tables();
            for (CatalogTableDescriptor table : tables) {
                this.tableSizeMap.putIfAbsent(table.id(), DEFAULT_VALUE);
            }
        }
    }

    @Override
    public void stop() {
        this.lowWatermark.removeListener(LowWatermarkEvent.LOW_WATERMARK_CHANGED, this.lwmListener);
        this.catalogService.removeListener(CatalogEvent.TABLE_DROP, this.dropTableEventListener);
        this.catalogService.removeListener(CatalogEvent.TABLE_CREATE, this.createTableEventListener);
    }

    private void onTableDrop(DropTableEventParameters parameters) {
        int tableId = parameters.tableId();
        int catalogVersion = parameters.catalogVersion();
        this.destructionEventsQueue.enqueue(new DestroyTableEvent(catalogVersion, tableId));
    }

    private void onTableCreate(CreateTableEventParameters parameters) {
        this.tableSizeMap.put(parameters.tableId(), DEFAULT_VALUE);
    }

    private void onLwmChanged(ChangeLowWatermarkEventParameters parameters) {
        int earliestVersion = this.catalogService.activeCatalogVersion(parameters.newLowWatermark().longValue());
        List<DestroyTableEvent> events = this.destructionEventsQueue.drainUpTo(earliestVersion);
        events.forEach(event -> this.tableSizeMap.remove(event.tableId()));
    }

    @TestOnly
    public long setThresholdTimeToPostponeUpdateMs(long milliseconds) {
        assert (milliseconds >= 0L);
        long prevValue = this.thresholdTimeToPostponeUpdateMs;
        this.thresholdTimeToPostponeUpdateMs = milliseconds;
        return prevValue;
    }

    @TestOnly
    public CompletableFuture<Void> lastUpdateStatisticFuture() {
        return this.latestUpdateFut.get();
    }

    @TestOnly
    public void forceUpdateAll() {
        List tableIds = List.copyOf(this.tableSizeMap.keySet());
        Iterator iterator = tableIds.iterator();
        while (iterator.hasNext()) {
            int tableId = (Integer)iterator.next();
            this.updateTableSizeStatistics(tableId, true);
        }
    }

    private static /* synthetic */ CompletableFuture lambda$updateTableSizeStatistics$4(CompletableFuture updateResult, CompletableFuture prev) {
        return prev == null ? updateResult : prev.thenCompose(none -> updateResult);
    }

    private static class ActualSize {
        long timestamp;
        long size;

        public ActualSize(long size, long timestamp) {
            this.timestamp = timestamp;
            this.size = size;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getSize() {
            return this.size;
        }
    }

    private static class DestroyTableEvent {
        final int catalogVersion;
        final int tableId;

        DestroyTableEvent(int catalogVersion, int tableId) {
            this.catalogVersion = catalogVersion;
            this.tableId = tableId;
        }

        public int catalogVersion() {
            return this.catalogVersion;
        }

        public int tableId() {
            return this.tableId;
        }
    }
}

