/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql.rbac;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDdl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.ignite3.internal.sql.engine.sql.rbac.GridgainSqlRbacDdl;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GridgainSqlGrantRoles
extends SqlDdl
implements GridgainSqlRbacDdl {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("GRANT", SqlKind.OTHER_DDL){

        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new GridgainSqlGrantRoles(pos, (SqlNodeList)operands[0], (SqlNodeList)operands[1]);
        }
    };
    private final SqlNodeList rolenames;
    private final SqlNodeList usernames;

    public GridgainSqlGrantRoles(SqlParserPos pos, SqlNodeList rolenames, SqlNodeList usernames) {
        super(OPERATOR, pos);
        this.rolenames = rolenames;
        this.usernames = usernames;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.rolenames, (Object)this.usernames);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("GRANT");
        GridgainSqlGrantRoles.unparseList(this.rolenames, writer, leftPrec, rightPrec);
        writer.keyword("TO");
        GridgainSqlGrantRoles.unparseList(this.usernames, writer, leftPrec, rightPrec);
    }

    private static void unparseList(SqlNodeList list, SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList("", "");
        for (SqlNode rolename : list) {
            writer.sep(",");
            rolename.unparse(writer, leftPrec, rightPrec);
        }
        writer.endList(frame);
    }

    public SqlNodeList rolenames() {
        return this.rolenames;
    }

    public SqlNodeList usernames() {
        return this.usernames;
    }

    public String toString() {
        return "GRANT " + this.rolenames + " TO " + this.usernames;
    }
}

