/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.memory.structures.file;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.ignite3.internal.fileio.FileIo;
import org.apache.ignite3.internal.fileio.FileIoFactory;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.file.FileIoTracker;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.file.TrackableFileIo;

public class TrackableFileIoFactory
implements FileIoFactory {
    private final FileIoFactory fileIoFactory;
    private final FileIoTracker ioTracker;

    public TrackableFileIoFactory(FileIoFactory fileIoFactory, FileIoTracker ioTracker) {
        this.fileIoFactory = Objects.requireNonNull(fileIoFactory, "fileIoFactory");
        this.ioTracker = Objects.requireNonNull(ioTracker, "ioTracker");
    }

    @Override
    public FileIo create(Path file, OpenOption ... modes) throws IOException {
        FileIo delegate = this.fileIoFactory.create(file, modes);
        TrackableFileIo fileIo = new TrackableFileIo(delegate, this.ioTracker);
        this.ioTracker.incrementOpenFds();
        return fileIo;
    }
}

