/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.memory.structures.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ignite3.internal.fileio.AbstractFileIo;
import org.apache.ignite3.internal.fileio.FileIo;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.file.FileIoTracker;

@NotThreadSafe
public final class TrackableFileIo
extends AbstractFileIo {
    private final FileIo fileIo;
    private long position;
    private long highestPosition;
    private final FileIoTracker fileIoTracker;
    private boolean closed;

    public TrackableFileIo(FileIo fileIo, FileIoTracker fileIoTracker) {
        this.fileIo = fileIo;
        this.fileIoTracker = fileIoTracker;
    }

    @Override
    public long position() throws IOException {
        return this.fileIo.position();
    }

    @Override
    public void position(long newPosition) throws IOException {
        this.advancePosition(newPosition);
        this.fileIo.position(newPosition);
        this.position = newPosition;
    }

    @Override
    public int read(ByteBuffer destBuf) throws IOException {
        int readCount = this.fileIo.read(destBuf);
        this.fileIoTracker.addBytesRead(readCount);
        return readCount;
    }

    @Override
    public int read(ByteBuffer destBuf, long position) throws IOException {
        int readCount = this.fileIo.read(destBuf, position);
        this.fileIoTracker.addBytesRead(readCount);
        return readCount;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int readCount = this.fileIo.read(buf, off, len);
        this.fileIoTracker.addBytesRead(readCount);
        return readCount;
    }

    @Override
    public int write(ByteBuffer srcBuf) throws IOException {
        int written = this.fileIo.write(srcBuf);
        this.advancePosition(this.position + (long)written);
        this.fileIoTracker.addBytesWritten(written);
        return written;
    }

    @Override
    public int write(ByteBuffer srcBuf, long position) throws IOException {
        int written = this.fileIo.write(srcBuf, position);
        this.advancePosition(position + (long)written);
        this.fileIoTracker.addBytesWritten(written);
        return written;
    }

    @Override
    public int write(byte[] buf, int off, int len) throws IOException {
        int written = this.fileIo.write(buf, off, len);
        this.advancePosition(this.position + (long)written);
        this.fileIoTracker.addBytesWritten(written);
        return written;
    }

    @Override
    public MappedByteBuffer map(int sizeBytes) throws IOException {
        return this.fileIo.map(sizeBytes);
    }

    @Override
    public void force() throws IOException {
        this.fileIo.force();
    }

    @Override
    public void force(boolean withMetadata) throws IOException {
        this.fileIo.force(withMetadata);
    }

    @Override
    public long size() throws IOException {
        return this.fileIo.size();
    }

    @Override
    public void clear() throws IOException {
        this.fileIo.clear();
        this.fileIoTracker.releaseSpace(this.highestPosition);
        this.highestPosition = 0L;
        this.position = 0L;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.fileIoTracker.releaseSpace(this.highestPosition);
        this.fileIoTracker.decrementOpenFds();
        this.fileIo.close();
    }

    private void advancePosition(long newPosition) {
        long d = newPosition - this.highestPosition;
        if (d > 0L) {
            this.fileIoTracker.acquireSpace(d);
            this.highestPosition = newPosition;
        }
        this.position = newPosition;
    }
}

