/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.memory;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.LongSupplier;
import java.util.function.ToLongFunction;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.network.serialization.Primitives;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.schema.BinaryTuplePrefix;
import org.apache.ignite3.internal.schema.BinaryTupleSchema;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.mapping.ColumnMapper;
import org.apache.ignite3.internal.schema.registry.UpgradingRowAdapter;
import org.apache.ignite3.internal.schema.row.RowImpl;
import org.apache.ignite3.internal.sql.engine.exec.SqlRowHandler;
import org.apache.ignite3.internal.sql.engine.exec.exp.agg.GroupKey;
import org.apache.ignite3.internal.sql.engine.exec.exp.agg.GroupState;
import org.apache.ignite3.internal.sql.engine.exec.row.RowSchema;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.ExtendedProjectedTuple;
import org.apache.ignite3.internal.sql.engine.util.FieldDeserializingProjectedTuple;
import org.apache.ignite3.internal.sql.engine.util.ProjectedTuple;
import org.apache.ignite3.internal.util.GridUnsafe;
import org.jetbrains.annotations.Nullable;

public final class ObjectSizeCalculator {
    private static final Map<Class<?>, SizeCalculatorImpl<Object>> SYS_CLS_SIZE = new IdentityHashMap();
    private static final long OBJ_HEADER_SIZE = GridUnsafe.objectFieldOffset(ObjectSizeCalculator.findField("field", Dummy.class));
    private static final long OBJ_ALIGN = ObjectSizeCalculator.calcAlign();
    private final Map<Class<?>, ClassInfo> additionalClasses = new IdentityHashMap();
    private final Map<Object, Object> processedObjects = new IdentityHashMap<Object, Object>();

    public ObjectSizeCalculator(List<Class<?>> classList) {
        for (Class<?> cls : classList) {
            if (Modifier.isAbstract(cls.getModifiers()) || cls.isInterface()) {
                throw new IllegalArgumentException(IgniteStringFormatter.format("Type {} should neither be abstract or an interface", cls));
            }
            ClassInfo classInfo = ObjectSizeCalculator.classInfo(cls);
            this.additionalClasses.put(cls, classInfo);
        }
    }

    public long sizeOf(@Nullable Object obj) {
        return this.sizeOf0(obj, true);
    }

    private long sizeOf0(@Nullable Object obj, boolean checkSelfReferences) {
        long size = this.calculateSizeOf(obj, checkSelfReferences);
        if (!this.processedObjects.isEmpty()) {
            this.processedObjects.clear();
        }
        return ObjectSizeCalculator.align(size);
    }

    private long calculateSizeOf(@Nullable Object obj, boolean checkSelfReferences) {
        if (obj == null) {
            return 0L;
        }
        Class<?> cls = obj.getClass();
        SizeCalculator sizeCalc = SYS_CLS_SIZE.get(cls);
        if (sizeCalc != null) {
            return sizeCalc.calcSize(this, obj);
        }
        if (ObjectSizeCalculator.isReferenceType(cls)) {
            return GridUnsafe.OBJ_REF_SIZE;
        }
        if (checkSelfReferences && this.processedObjects.put(obj, obj) != null) {
            return 0L;
        }
        if (cls.isArray()) {
            long base = GridUnsafe.arrayBaseOffset(cls);
            long scale = GridUnsafe.arrayIndexScale(cls);
            long size = ObjectSizeCalculator.align(base + scale * (long)Array.getLength(obj));
            if (!cls.getComponentType().isPrimitive()) {
                Object[] arr = (Object[])obj;
                for (int i = 0; i < arr.length; ++i) {
                    size += this.sizeOf0(arr[i], checkSelfReferences);
                }
            }
            return size;
        }
        ClassInfo classInfo = this.additionalClasses.get(cls);
        if (classInfo == null) {
            String error = IgniteStringFormatter.format("Unexpected row object: {}, registered classes: {}", cls, this.additionalClasses.keySet());
            throw new IllegalArgumentException(error);
        }
        return this.reflectiveObjectSize(classInfo, obj);
    }

    private long reflectiveObjectSize(ClassInfo classInfo, Object obj) {
        long size = classInfo.instanceSize;
        for (Field f : classInfo.refFields) {
            try {
                Object fieldValue = f.get(obj);
                Class<?> fieldType = f.getType();
                long fieldSize = fieldType.isPrimitive() ? (long)Primitives.widthInBytes(fieldType) : this.sizeOf0(fieldValue, true);
                size += fieldSize;
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return size;
    }

    private static <T> void addSysClsSize(Class<T> cls, @Nullable SizeCalculator<T> extraSizeCalc) {
        ClassInfo classInfo = ObjectSizeCalculator.classInfo(cls);
        if (extraSizeCalc == null) {
            SYS_CLS_SIZE.put(cls, new SizeCalculatorImpl<Object>(cls, classInfo, (c, val) -> 0L));
        } else {
            SYS_CLS_SIZE.put(cls, new SizeCalculatorImpl<T>(cls, classInfo, extraSizeCalc));
        }
    }

    private static ClassInfo classInfo(Class<?> cls) {
        long size = 0L;
        ArrayList<Field> refFields = new ArrayList<Field>();
        if (ObjectSizeCalculator.isReferenceType(cls)) {
            return new ClassInfo(OBJ_HEADER_SIZE, Collections.emptyList());
        }
        while (cls != null && cls != Object.class) {
            for (Field f : cls.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                Class<?> fieldType = f.getDeclaringClass();
                long fieldOffsetPlusSize = ObjectSizeCalculator.fieldHolderSize(fieldType) + GridUnsafe.objectFieldOffset(f);
                size = Math.max(size, fieldOffsetPlusSize);
                if (fieldType.isPrimitive()) continue;
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                refFields.add(f);
            }
            cls = cls.getSuperclass();
        }
        return new ClassInfo(ObjectSizeCalculator.align(Math.max(size, OBJ_HEADER_SIZE)), refFields);
    }

    static boolean isReferenceType(Class<?> cls) {
        return SchemaDescriptor.class.isAssignableFrom(cls) || RowSchema.class.isAssignableFrom(cls) || BinaryTupleSchema.class.isAssignableFrom(cls) || ColumnMapper.class.isAssignableFrom(cls);
    }

    private static long calcAlign() {
        if (OBJ_HEADER_SIZE == (long)GridUnsafe.ADDR_SIZE) {
            return OBJ_HEADER_SIZE;
        }
        return Commons.nextPowerOf2(Math.max(GridUnsafe.ADDR_SIZE, (int)(Runtime.getRuntime().maxMemory() >> 32)));
    }

    private static long fieldHolderSize(Class<?> fieldType) {
        if (fieldType.isPrimitive()) {
            return Primitives.widthInBytes(fieldType);
        }
        return GridUnsafe.OBJ_REF_SIZE;
    }

    private static long arraySize(long arrayOffset, long elementSize, int length) {
        return arrayOffset + (long)length * elementSize;
    }

    private static long align(long size) {
        return size + (OBJ_ALIGN - 1L) & -OBJ_ALIGN;
    }

    private static Field findField(String fieldName, Class<?> declaringClass) {
        try {
            return declaringClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(IgniteStringFormatter.format("Field does not exist: {}. class: {}", fieldName, declaringClass), e);
        }
    }

    static {
        ObjectSizeCalculator.addSysClsSize(Boolean.class, null);
        ObjectSizeCalculator.addSysClsSize(Byte.class, null);
        ObjectSizeCalculator.addSysClsSize(Short.class, null);
        ObjectSizeCalculator.addSysClsSize(Integer.class, null);
        ObjectSizeCalculator.addSysClsSize(Float.class, null);
        ObjectSizeCalculator.addSysClsSize(Long.class, null);
        ObjectSizeCalculator.addSysClsSize(Double.class, null);
        ObjectSizeCalculator.addSysClsSize(ByteString.class, (c, s) -> ObjectSizeCalculator.align(ObjectSizeCalculator.arraySize(GridUnsafe.BYTE_ARR_OFF, s.length(), 1)));
        ObjectSizeCalculator.addSysClsSize(String.class, (c, s) -> ObjectSizeCalculator.align(ObjectSizeCalculator.arraySize(GridUnsafe.CHAR_ARR_OFF, s.length(), 2)));
        ObjectSizeCalculator.addSysClsSize(BigInteger.class, (c, bi) -> ObjectSizeCalculator.align(GridUnsafe.INT_ARR_OFF + (long)(bi.bitLength() + 31 >> 5) << 2));
        ObjectSizeCalculator.addSysClsSize(BigDecimal.class, (c, bd) -> c.sizeOf0(bd.unscaledValue(), false));
        ObjectSizeCalculator.addSysClsSize(Instant.class, null);
        ObjectSizeCalculator.addSysClsSize(LocalDate.class, null);
        ObjectSizeCalculator.addSysClsSize(LocalTime.class, null);
        long locDateTimeExtraSize = ObjectSizeCalculator.classInfo(LocalDate.class).instanceSize + ObjectSizeCalculator.classInfo(LocalTime.class).instanceSize;
        ObjectSizeCalculator.addSysClsSize(LocalDateTime.class, (c, dt) -> locDateTimeExtraSize);
        ObjectSizeCalculator.addSysClsSize(Period.class, null);
        ObjectSizeCalculator.addSysClsSize(Duration.class, null);
        ObjectSizeCalculator.addSysClsSize(UUID.class, null);
        ClassInfo byteBufInfo = ObjectSizeCalculator.classInfo(ByteBuffer.allocate(2).getClass());
        long byteBufferInstSize = byteBufInfo.instanceSize;
        SizeCalculator<BinaryTuple> binTupleSizeCalc = (c, t) -> {
            long byteBufSize = ObjectSizeCalculator.align(t.size());
            long byteBufArrayOverhead = OBJ_HEADER_SIZE + GridUnsafe.OBJ_REF_SIZE + 32L;
            return byteBufferInstSize + byteBufSize + byteBufArrayOverhead;
        };
        ObjectSizeCalculator.addSysClsSize(BinaryTuple.class, binTupleSizeCalc);
        ObjectSizeCalculator.addSysClsSize(BinaryTuplePrefix.class, binTupleSizeCalc);
        SizeCalculator<RowImpl> rowSizeCalc = (c, t) -> byteBufferInstSize + ObjectSizeCalculator.align(t.size());
        ObjectSizeCalculator.addSysClsSize(RowImpl.class, rowSizeCalc);
        long rowImplInstanceSize = ObjectSizeCalculator.classInfo(RowImpl.class).instanceSize;
        SizeCalculator<UpgradingRowAdapter> rowAdapterSizeCalc = (c, t) -> byteBufferInstSize + rowImplInstanceSize + ObjectSizeCalculator.align(t.size());
        ObjectSizeCalculator.addSysClsSize(UpgradingRowAdapter.class, rowAdapterSizeCalc);
        long tupleInstSize = ObjectSizeCalculator.classInfo(BinaryTuple.class).instanceSize;
        ToLongFunction<LongSupplier> projectionSize = t -> ObjectSizeCalculator.arraySize(GridUnsafe.INT_ARR_OFF, t.getAsLong(), 32);
        ObjectSizeCalculator.addSysClsSize(ProjectedTuple.class, (c, t) -> tupleInstSize + byteBufferInstSize + ObjectSizeCalculator.align(t.size()) + projectionSize.applyAsLong(t::projectionSize));
        ObjectSizeCalculator.addSysClsSize(FieldDeserializingProjectedTuple.class, (c, t) -> tupleInstSize + byteBufferInstSize + ObjectSizeCalculator.align(t.size()) + projectionSize.applyAsLong(t::projectionSize));
        ObjectSizeCalculator.addSysClsSize(GroupKey.class, (c, t) -> OBJ_HEADER_SIZE + ObjectSizeCalculator.arraySize(GridUnsafe.OBJ_ARRAY_OFFSET, GridUnsafe.OBJ_REF_SIZE, t.fieldsCount()));
        ObjectSizeCalculator.addSysClsSize(SqlRowHandler.BinaryTupleRowWrapper.class, (c, t) -> GridUnsafe.OBJ_REF_SIZE + GridUnsafe.OBJ_REF_SIZE + c.sizeOf(t.tuple()));
        ObjectSizeCalculator.addSysClsSize(SqlRowHandler.ObjectsArrayRowWrapper.class, (c, t) -> {
            int columnsCount = t.columnsCount();
            long objArraySize = ObjectSizeCalculator.arraySize(GridUnsafe.OBJ_ARRAY_OFFSET, GridUnsafe.OBJ_REF_SIZE, columnsCount);
            long rowSize = GridUnsafe.OBJ_REF_SIZE + ObjectSizeCalculator.align(objArraySize);
            for (int i = 0; i < columnsCount; ++i) {
                Object val = t.get(i);
                rowSize += c.sizeOf(val);
            }
            return rowSize;
        });
        ObjectSizeCalculator.addSysClsSize(GroupState.class, (c, t) -> {
            int aggCount = t.state().size();
            long objArraySize = ObjectSizeCalculator.arraySize(GridUnsafe.OBJ_ARRAY_OFFSET, GridUnsafe.OBJ_REF_SIZE, aggCount);
            return GridUnsafe.OBJ_REF_SIZE + ObjectSizeCalculator.align(objArraySize);
        });
        ObjectSizeCalculator.addSysClsSize(ExtendedProjectedTuple.class, (c, t) -> tupleInstSize + byteBufferInstSize + ObjectSizeCalculator.align(t.size()) + projectionSize.applyAsLong(t::projectionSize));
    }

    private static class ClassInfo {
        private final long instanceSize;
        private final List<Field> refFields;

        private ClassInfo(long instanceSize, List<Field> refFields) {
            this.instanceSize = instanceSize;
            this.refFields = refFields;
        }
    }

    @FunctionalInterface
    private static interface SizeCalculator<T> {
        public long calcSize(ObjectSizeCalculator var1, T var2);
    }

    private static class SizeCalculatorImpl<T>
    implements SizeCalculator<T> {
        private final Class<?> cls;
        private final long instanceSize;
        private final SizeCalculator<T> extraSizeCalc;

        private SizeCalculatorImpl(Class<?> cls, ClassInfo classInfo, SizeCalculator<T> extraSizeCalc) {
            this.cls = cls;
            this.instanceSize = classInfo.instanceSize;
            this.extraSizeCalc = extraSizeCalc;
        }

        @Override
        public long calcSize(ObjectSizeCalculator calculator, T val) {
            long extra = this.extraSizeCalc.calcSize(calculator, val);
            return this.instanceSize + extra;
        }
    }

    private static class Dummy {
        public byte field;

        private Dummy() {
        }
    }
}

