/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.fsm;

import java.time.Instant;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite3.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite3.internal.sql.engine.InternalSqlRow;
import org.apache.ignite3.internal.sql.engine.QueryCancel;
import org.apache.ignite3.internal.sql.engine.SqlOperationContext;
import org.apache.ignite3.internal.sql.engine.SqlProperties;
import org.apache.ignite3.internal.sql.engine.exec.fsm.ExecutionPhase;
import org.apache.ignite3.internal.sql.engine.exec.fsm.QueryExecutor;
import org.apache.ignite3.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite3.internal.sql.engine.sql.ParsedResult;
import org.apache.ignite3.internal.sql.engine.tx.QueryTransactionContext;
import org.apache.ignite3.internal.sql.engine.tx.QueryTransactionWrapper;
import org.gridgain.internal.security.context.SecurityContext;
import org.jetbrains.annotations.Nullable;

class Query {
    final CompletableFuture<Void> terminationFuture = new CompletableFuture();
    volatile CompletableFuture<Object> resultHolder = new CompletableFuture();
    final SecurityContext securityContext;
    final Instant createdAt;
    @Nullable
    final UUID parentId;
    final int statementNum;
    final UUID id;
    final String sql;
    final Object[] params;
    final QueryCancel cancel = new QueryCancel();
    final QueryExecutor executor;
    final SqlProperties properties;
    final QueryTransactionContext txContext;
    final AtomicReference<Throwable> error = new AtomicReference();
    @Nullable
    final CompletableFuture<AsyncSqlCursor<InternalSqlRow>> nextCursorFuture;
    @Nullable
    volatile ParsedResult parsedResult = null;
    @Nullable
    volatile SqlOperationContext operationContext = null;
    @Nullable
    volatile QueryPlan plan = null;
    @Nullable
    volatile QueryTransactionWrapper usedTransaction = null;
    @Nullable
    volatile AsyncSqlCursor<InternalSqlRow> cursor = null;
    @Nullable
    volatile List<ParsedResult> parsedScript = null;
    private volatile ExecutionPhase currentPhase = ExecutionPhase.REGISTERED;

    Query(SecurityContext securityContext, Instant createdAt, QueryExecutor executor, UUID id, String sql, SqlProperties properties, QueryTransactionContext txContext, Object[] params) {
        this.securityContext = securityContext;
        this.createdAt = createdAt;
        this.executor = executor;
        this.id = id;
        this.sql = sql;
        this.properties = properties;
        this.txContext = txContext;
        this.params = params;
        this.parentId = null;
        this.statementNum = -1;
        this.nextCursorFuture = null;
    }

    Query(Instant createdAt, Query parent, ParsedResult parsedResult, int statementNum, UUID id, QueryTransactionContext txContext, Object[] params, @Nullable CompletableFuture<AsyncSqlCursor<InternalSqlRow>> nextCursorFuture) {
        this.securityContext = parent.securityContext;
        this.createdAt = createdAt;
        this.executor = parent.executor;
        this.parentId = parent.id;
        this.statementNum = statementNum;
        this.id = id;
        this.sql = parsedResult.originalQuery();
        this.properties = parent.properties;
        this.txContext = txContext;
        this.params = params;
        this.nextCursorFuture = nextCursorFuture;
        this.parsedResult = parsedResult;
    }

    void moveTo(ExecutionPhase newPhase) {
        this.currentPhase = newPhase;
        if (newPhase == ExecutionPhase.TERMINATED) {
            this.terminationFuture.complete(null);
        }
    }

    ExecutionPhase currentPhase() {
        return this.currentPhase;
    }

    void onError(Throwable th) {
        this.setError(th);
        this.moveTo(ExecutionPhase.TERMINATED);
        this.resultHolder.completeExceptionally(th);
    }

    void setError(Throwable err) {
        Throwable prevErr = this.error.compareAndExchange(null, err);
        if (prevErr != null && prevErr != err) {
            this.error.get().addSuppressed(err);
        }
    }

    CompletableFuture<Void> cancel() {
        this.cancel.cancel();
        return this.terminationFuture;
    }

    void reset() {
        this.resultHolder = new CompletableFuture();
        this.error.set(null);
    }
}

