/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.ddl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.apache.ignite3.internal.catalog.CatalogApplyResult;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.catalog.commands.AbstractCacheCommand;
import org.apache.ignite3.internal.catalog.commands.AbstractCreateIndexCommand;
import org.apache.ignite3.internal.catalog.commands.AbstractSequenceCommand;
import org.apache.ignite3.internal.catalog.commands.AbstractTableCommand;
import org.apache.ignite3.internal.catalog.commands.AlterCacheDropExpireCommand;
import org.apache.ignite3.internal.catalog.commands.AlterCacheSetExpireCommand;
import org.apache.ignite3.internal.catalog.commands.AlterSequenceCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableAddColumnCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableAddSecondaryZoneCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableAlterColumnCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableDropColumnCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableDropExpireCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableDropSecondaryZoneCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableSetExpireCommand;
import org.apache.ignite3.internal.catalog.commands.AlterZoneCommand;
import org.apache.ignite3.internal.catalog.commands.AlterZoneSetDefaultCommand;
import org.apache.ignite3.internal.catalog.commands.ColumnParams;
import org.apache.ignite3.internal.catalog.commands.CreateCacheCommand;
import org.apache.ignite3.internal.catalog.commands.CreateSchemaCommand;
import org.apache.ignite3.internal.catalog.commands.CreateSequenceCommand;
import org.apache.ignite3.internal.catalog.commands.CreateTableCommand;
import org.apache.ignite3.internal.catalog.commands.CreateZoneCommand;
import org.apache.ignite3.internal.catalog.commands.DefaultValue;
import org.apache.ignite3.internal.catalog.commands.DeferredDefaultValue;
import org.apache.ignite3.internal.catalog.commands.DropCacheCommand;
import org.apache.ignite3.internal.catalog.commands.DropIndexCommand;
import org.apache.ignite3.internal.catalog.commands.DropSchemaCommand;
import org.apache.ignite3.internal.catalog.commands.DropSequenceCommand;
import org.apache.ignite3.internal.catalog.commands.DropTableCommand;
import org.apache.ignite3.internal.catalog.commands.DropZoneCommand;
import org.apache.ignite3.internal.catalog.commands.RenameZoneCommand;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.sql.engine.exec.ddl.DdlCommandHandler;
import org.apache.ignite3.internal.sql.engine.sql.fun.GridgainSqlOperatorTable;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.rbac.Rbac;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.Selector;

public class SecuredDdlCommandHandler
extends DdlCommandHandler {
    private final Authorizer authorizer;

    public SecuredDdlCommandHandler(CatalogManager catalogManager, Rbac rbac, ClockService clockService, LicenseFeatureChecker licenseFeatureChecker) {
        super(catalogManager, clockService, licenseFeatureChecker);
        this.authorizer = rbac.authorizer();
    }

    @Override
    public CompletableFuture<CatalogApplyResult> handle(List<CatalogCommand> batch) {
        ArrayList authorizationResults = new ArrayList(batch.size());
        for (CatalogCommand item : batch) {
            authorizationResults.add(this.authorizeThenCompose(item, ignored -> CompletableFutures.nullCompletedFuture()));
        }
        return CompletableFutures.allOf(authorizationResults).thenCompose(none -> super.handle(batch));
    }

    @Override
    public CompletableFuture<CatalogApplyResult> handle(CatalogCommand cmd) {
        Objects.requireNonNull(cmd, "cmd");
        return this.authorizeThenCompose(cmd, x$0 -> super.handle((CatalogCommand)x$0));
    }

    private <T> CompletableFuture<T> authorizeThenCompose(CatalogCommand command, Function<CatalogCommand, CompletableFuture<T>> action) {
        CompletableFuture<Void> authorizationResult;
        if (command instanceof CreateSchemaCommand) {
            authorizationResult = this.authorizeCreateSchema((CreateSchemaCommand)command);
        } else if (command instanceof DropSchemaCommand) {
            authorizationResult = this.authorizeDropSchema((DropSchemaCommand)command);
        } else if (command instanceof CreateTableCommand) {
            authorizationResult = this.authorizeCreateTable((CreateTableCommand)command);
        } else if (command instanceof DropTableCommand) {
            authorizationResult = this.authorizeDropTable((DropTableCommand)command);
        } else if (command instanceof AlterTableAddColumnCommand) {
            authorizationResult = this.authorizeAlterAddColumn((AlterTableAddColumnCommand)command);
        } else if (command instanceof AlterTableDropColumnCommand) {
            authorizationResult = this.authorizeAlterDropColumn((AlterTableDropColumnCommand)command);
        } else if (command instanceof AlterTableSetExpireCommand) {
            authorizationResult = this.authorizeAlterTableSetExpire((AlterTableSetExpireCommand)command);
        } else if (command instanceof AlterTableDropExpireCommand) {
            authorizationResult = this.authorizeAlterTableDropExpire((AlterTableDropExpireCommand)command);
        } else if (command instanceof AlterTableAlterColumnCommand) {
            authorizationResult = this.authorizeAlterColumn((AlterTableAlterColumnCommand)command);
        } else if (command instanceof AbstractCreateIndexCommand) {
            authorizationResult = this.authorizeCreateIndex((AbstractCreateIndexCommand)command);
        } else if (command instanceof DropIndexCommand) {
            authorizationResult = this.authorizeDropIndex((DropIndexCommand)command);
        } else if (command instanceof CreateZoneCommand) {
            authorizationResult = this.authorizeCreateZone();
        } else if (command instanceof RenameZoneCommand) {
            authorizationResult = this.authorizeAlterZone();
        } else if (command instanceof AlterZoneCommand) {
            authorizationResult = this.authorizeAlterZone();
        } else if (command instanceof AlterZoneSetDefaultCommand) {
            authorizationResult = this.authorizeAlterZone();
        } else if (command instanceof DropZoneCommand) {
            authorizationResult = this.authorizeDropZone();
        } else if (command instanceof AlterTableAddSecondaryZoneCommand) {
            authorizationResult = this.authorizeAlterTableAddSecondaryZone((AlterTableAddSecondaryZoneCommand)command);
        } else if (command instanceof AlterTableDropSecondaryZoneCommand) {
            authorizationResult = this.authorizeAlterTableDropSecondaryZone((AlterTableDropSecondaryZoneCommand)command);
        } else if (command instanceof CreateSequenceCommand) {
            authorizationResult = this.authorizeCreateSequence((CreateSequenceCommand)command);
        } else if (command instanceof DropSequenceCommand) {
            authorizationResult = this.authorizeDropSequence((DropSequenceCommand)command);
        } else if (command instanceof AlterSequenceCommand) {
            authorizationResult = this.authorizeAlterSequence((AlterSequenceCommand)command);
        } else if (command instanceof CreateCacheCommand) {
            authorizationResult = this.authorizeCreateCache((CreateCacheCommand)command);
        } else if (command instanceof DropCacheCommand) {
            authorizationResult = this.authorizeDropCache((DropCacheCommand)command);
        } else if (command instanceof AlterCacheSetExpireCommand) {
            authorizationResult = this.authorizeAlterCacheSetExpire((AlterCacheSetExpireCommand)command);
        } else if (command instanceof AlterCacheDropExpireCommand) {
            authorizationResult = this.authorizeAlterCacheDropExpire((AlterCacheDropExpireCommand)command);
        } else {
            throw new UnsupportedOperationException("Unsupported command: " + command.getClass().getCanonicalName());
        }
        return authorizationResult.thenCompose(none -> (CompletionStage)action.apply(command));
    }

    private CompletableFuture<Void> authorizeCreateZone() {
        return this.authorizer.authorizeAsync(Action.CREATE_DISTRIBUTION_ZONE);
    }

    private CompletableFuture<Void> authorizeAlterZone() {
        return this.authorizer.authorizeAsync(Action.ALTER_DISTRIBUTION_ZONE);
    }

    private CompletableFuture<Void> authorizeDropZone() {
        return this.authorizer.authorizeAsync(Action.DROP_DISTRIBUTION_ZONE);
    }

    private CompletableFuture<Void> authorizeCreateSchema(CreateSchemaCommand cmd) {
        Privilege privilege = Privilege.builder().action(Action.CREATE_SCHEMA).selector(Selector.schema(cmd.schemaName())).build();
        return this.authorizer.authorizeAsync(privilege);
    }

    private CompletableFuture<Void> authorizeDropSchema(DropSchemaCommand cmd) {
        Privilege privilege = Privilege.builder().action(Action.DROP_SCHEMA).selector(Selector.schema(cmd.schemaName())).build();
        return this.authorizer.authorizeAsync(privilege);
    }

    private CompletableFuture<Void> authorizeCreateTable(CreateTableCommand cmd) {
        HashSet<Privilege> privileges = new HashSet<Privilege>();
        privileges.add(SecuredDdlCommandHandler.getTablePrivilege(Action.CREATE_TABLE, cmd));
        privileges.addAll(SecuredDdlCommandHandler.getFunctionPrivileges(cmd.columns()));
        return this.authorizer.authorizeAsync(privileges);
    }

    private CompletableFuture<Void> authorizeDropTable(DropTableCommand cmd) {
        return this.authorizer.authorizeAsync(SecuredDdlCommandHandler.getTablePrivilege(Action.DROP_TABLE, cmd));
    }

    private CompletableFuture<Void> authorizeAlterTableSetExpire(AlterTableSetExpireCommand cmd) {
        return this.authorizer.authorizeAsync(SecuredDdlCommandHandler.getTablePrivilege(Action.ALTER_TABLE, cmd));
    }

    private CompletableFuture<Void> authorizeAlterTableDropExpire(AlterTableDropExpireCommand cmd) {
        return this.authorizer.authorizeAsync(SecuredDdlCommandHandler.getTablePrivilege(Action.ALTER_TABLE, cmd));
    }

    private CompletableFuture<Void> authorizeAlterAddColumn(AlterTableAddColumnCommand cmd) {
        return this.authorizer.authorizeAsync(SecuredDdlCommandHandler.getTablePrivilege(Action.ALTER_TABLE, cmd));
    }

    private CompletableFuture<Void> authorizeAlterDropColumn(AlterTableDropColumnCommand cmd) {
        return this.authorizer.authorizeAsync(SecuredDdlCommandHandler.getTablePrivilege(Action.ALTER_TABLE, cmd));
    }

    private CompletableFuture<Void> authorizeAlterColumn(AlterTableAlterColumnCommand cmd) {
        return this.authorizer.authorizeAsync(SecuredDdlCommandHandler.getTablePrivilege(Action.ALTER_TABLE, cmd));
    }

    private CompletableFuture<Void> authorizeCreateIndex(AbstractCreateIndexCommand cmd) {
        Privilege privilege = Privilege.builder().action(Action.CREATE_INDEX).selector(Selector.table(cmd.schemaName(), cmd.indexName())).build();
        return this.authorizer.authorizeAsync(privilege);
    }

    private CompletableFuture<Void> authorizeDropIndex(DropIndexCommand cmd) {
        Privilege privilege = Privilege.builder().action(Action.DROP_INDEX).selector(Selector.table(cmd.schemaName(), cmd.indexName())).build();
        return this.authorizer.authorizeAsync(privilege);
    }

    private CompletableFuture<Void> authorizeAlterTableAddSecondaryZone(AlterTableAddSecondaryZoneCommand cmd) {
        return this.authorizer.authorizeAsync(SecuredDdlCommandHandler.getTablePrivilege(Action.ALTER_TABLE, cmd));
    }

    private CompletableFuture<Void> authorizeAlterTableDropSecondaryZone(AlterTableDropSecondaryZoneCommand cmd) {
        return this.authorizer.authorizeAsync(SecuredDdlCommandHandler.getTablePrivilege(Action.ALTER_TABLE, cmd));
    }

    private CompletableFuture<Void> authorizeCreateSequence(CreateSequenceCommand cmd) {
        return this.authorizer.authorizeAsync(SecuredDdlCommandHandler.getSequencePrivilege(Action.CREATE_SEQUENCE, cmd));
    }

    private CompletableFuture<Void> authorizeAlterSequence(AlterSequenceCommand cmd) {
        return this.authorizer.authorizeAsync(SecuredDdlCommandHandler.getSequencePrivilege(Action.ALTER_SEQUENCE, cmd));
    }

    private CompletableFuture<Void> authorizeDropSequence(DropSequenceCommand cmd) {
        return this.authorizer.authorizeAsync(SecuredDdlCommandHandler.getSequencePrivilege(Action.DROP_SEQUENCE, cmd));
    }

    private CompletableFuture<Void> authorizeCreateCache(CreateCacheCommand cmd) {
        HashSet<Privilege> privileges = new HashSet<Privilege>();
        privileges.add(SecuredDdlCommandHandler.getCachePrivilege(Action.CREATE_TABLE, cmd));
        privileges.addAll(SecuredDdlCommandHandler.getFunctionPrivileges(cmd.columns()));
        return this.authorizer.authorizeAsync(privileges);
    }

    private CompletableFuture<Void> authorizeDropCache(DropCacheCommand cmd) {
        return this.authorizer.authorizeAsync(SecuredDdlCommandHandler.getCachePrivilege(Action.DROP_TABLE, cmd));
    }

    private CompletableFuture<Void> authorizeAlterCacheSetExpire(AlterCacheSetExpireCommand cmd) {
        return this.authorizer.authorizeAsync(SecuredDdlCommandHandler.getCachePrivilege(Action.ALTER_TABLE, cmd));
    }

    private CompletableFuture<Void> authorizeAlterCacheDropExpire(AlterCacheDropExpireCommand cmd) {
        return this.authorizer.authorizeAsync(SecuredDdlCommandHandler.getCachePrivilege(Action.ALTER_TABLE, cmd));
    }

    private static Privilege getTablePrivilege(Action action, AbstractTableCommand cmd) {
        return Privilege.builder().action(action).selector(Selector.table(cmd.schemaName(), cmd.tableName())).build();
    }

    private static Privilege getSequencePrivilege(Action action, AbstractSequenceCommand cmd) {
        return Privilege.builder().action(action).selector(Selector.sequence(cmd.schemaName(), cmd.sequenceName())).build();
    }

    private static Privilege getCachePrivilege(Action action, AbstractCacheCommand cmd) {
        return Privilege.builder().action(action).selector(Selector.table(cmd.schemaName(), cmd.cacheName())).build();
    }

    private static List<Privilege> getFunctionPrivileges(List<ColumnParams> columns) {
        ArrayList<Privilege> res = new ArrayList<Privilege>(columns.size());
        for (ColumnParams c : columns) {
            if (c.defaultValueDefinition().type() != DefaultValue.Type.FUNCTION_CALL) continue;
            DeferredDefaultValue.FunctionCall func = (DeferredDefaultValue.FunctionCall)c.defaultValueDefinition();
            if (!GridgainSqlOperatorTable.NEXTVAL.getName().equalsIgnoreCase(func.functionName())) continue;
            String name = (String)func.parameters().get(1);
            res.add(Privilege.builder().action(Action.USE_SEQUENCE).selector(Selector.sequence(name)).build());
        }
        return res;
    }
}

