/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.ignite3.internal.components.NodeProperties;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.replicator.ReplicaService;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaManager;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.sql.engine.exec.ExecutableSequence;
import org.apache.ignite3.internal.sql.engine.exec.ExecutableSequenceImpl;
import org.apache.ignite3.internal.sql.engine.exec.ExecutableTable;
import org.apache.ignite3.internal.sql.engine.exec.ExecutableTableRegistry;
import org.apache.ignite3.internal.sql.engine.exec.ScannableTable;
import org.apache.ignite3.internal.sql.engine.exec.ScannableTableImpl;
import org.apache.ignite3.internal.sql.engine.exec.SecondaryStorageScannableTableImpl;
import org.apache.ignite3.internal.sql.engine.exec.SecondaryStoreRowConverterFactory;
import org.apache.ignite3.internal.sql.engine.exec.TableRowConverter;
import org.apache.ignite3.internal.sql.engine.exec.TableRowConverterFactoryImpl;
import org.apache.ignite3.internal.sql.engine.exec.UpdatableTable;
import org.apache.ignite3.internal.sql.engine.exec.UpdatableTableImpl;
import org.apache.ignite3.internal.sql.engine.schema.IgniteSequence;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.schema.PartitionCalculator;
import org.apache.ignite3.internal.sql.engine.schema.SqlSchemaManager;
import org.apache.ignite3.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite3.internal.sql.engine.util.cache.Cache;
import org.apache.ignite3.internal.sql.engine.util.cache.CacheFactory;
import org.apache.ignite3.internal.table.InternalTable;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.internal.table.distributed.TableManager;
import org.apache.ignite3.table.KeyValueView;
import org.jetbrains.annotations.Nullable;

public class ExecutableTableRegistryImpl
implements ExecutableTableRegistry {
    private final TableManager tableManager;
    private final SqlSchemaManager sqlSchemaManager;
    private final SchemaManager schemaManager;
    private final ReplicaService replicaService;
    private final ClockService clockService;
    private final NodeProperties nodeProperties;
    final Cache<CacheKey, ExecutableTable> tableCache;
    final ConcurrentMap<CacheKey, ExecutableSequence> sequenceCache;

    public ExecutableTableRegistryImpl(TableManager tableManager, SchemaManager schemaManager, SqlSchemaManager sqlSchemaManager, ReplicaService replicaService, ClockService clockService, NodeProperties nodeProperties, int cacheSize, CacheFactory cacheFactory) {
        this.sqlSchemaManager = sqlSchemaManager;
        this.tableManager = tableManager;
        this.schemaManager = schemaManager;
        this.replicaService = replicaService;
        this.clockService = clockService;
        this.nodeProperties = nodeProperties;
        this.tableCache = cacheFactory.create(cacheSize);
        this.sequenceCache = Caffeine.newBuilder().maximumSize((long)cacheSize).build().asMap();
    }

    @Override
    public ExecutableTable getTable(int catalogVersion, int tableId) {
        IgniteTable sqlTable = this.sqlSchemaManager.table(catalogVersion, tableId);
        return this.tableCache.get(ExecutableTableRegistryImpl.cacheKey(tableId, sqlTable.version()), k -> this.loadTable(sqlTable));
    }

    @Override
    public ExecutableSequence getSequence(int sequenceId) {
        IgniteSequence sqlSequence = this.sqlSchemaManager.sequence(sequenceId);
        return this.sequenceCache.computeIfAbsent(ExecutableTableRegistryImpl.cacheKey(sequenceId, sqlSequence.version()), k -> this.loadSequence(sqlSequence));
    }

    private ExecutableTable loadTable(IgniteTable sqlTable) {
        TableViewInternal table = this.tableManager.cachedTable(sqlTable.id());
        assert (table != null) : "Table not found: tableId=" + sqlTable.id();
        TableDescriptor tableDescriptor = sqlTable.descriptor();
        SchemaRegistry schemaRegistry = this.schemaManager.schemaRegistry(sqlTable.id());
        SchemaDescriptor schemaDescriptor = schemaRegistry.schema(sqlTable.version());
        TableRowConverterFactoryImpl converterFactory = new TableRowConverterFactoryImpl(tableDescriptor, schemaRegistry, schemaDescriptor);
        InternalTable internalTable = table.internalTable();
        ScannableTableImpl scannableTable = new ScannableTableImpl(internalTable, converterFactory);
        TableRowConverter rowConverter = converterFactory.create(null);
        assert (!sqlTable.useSecondaryStorage());
        UpdatableTableImpl updatableTable = new UpdatableTableImpl(sqlTable.id(), sqlTable.zoneId(), tableDescriptor, internalTable.partitions(), internalTable, this.replicaService, this.clockService, this.nodeProperties, rowConverter);
        if (internalTable.hasSecondaryStorage()) {
            SecondaryStoreRowConverterFactory replicaConverterFactory = new SecondaryStoreRowConverterFactory(tableDescriptor, schemaRegistry, schemaDescriptor);
            SecondaryStorageScannableTableImpl replicaTable = new SecondaryStorageScannableTableImpl(internalTable, replicaConverterFactory);
            return new ExecutableTableImpl(scannableTable, replicaTable, updatableTable, sqlTable.partitionCalculator());
        }
        return new ExecutableTableImpl(scannableTable, updatableTable, sqlTable.partitionCalculator());
    }

    private ExecutableSequence loadSequence(IgniteSequence sqlSequence) {
        TableViewInternal tableViewInternal = this.tableManager.cachedTable(sqlSequence.tableId());
        KeyValueView<Long, Long> view = tableViewInternal.keyValueView(Long.class, Long.class);
        return new ExecutableSequenceImpl(sqlSequence.name(), sqlSequence.id(), sqlSequence.increment(), sqlSequence.minValue(), sqlSequence.maxValue(), sqlSequence.start(), sqlSequence.cacheValue(), view);
    }

    private static CacheKey cacheKey(int tableId, int version) {
        return new CacheKey(tableId, version);
    }

    private static class CacheKey {
        private final int tableId;
        private final int tableVersion;

        CacheKey(int tableId, int tableVersion) {
            this.tableId = tableId;
            this.tableVersion = tableVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.tableVersion == cacheKey.tableVersion && this.tableId == cacheKey.tableId;
        }

        public int hashCode() {
            return Objects.hash(this.tableVersion, this.tableId);
        }
    }

    private static final class ExecutableTableImpl
    implements ExecutableTable {
        private final ScannableTable scannableTable;
        @Nullable
        private final ScannableTable secondaryStorageTable;
        private final UpdatableTable updatableTable;
        private final Supplier<PartitionCalculator> partitionCalculator;

        private ExecutableTableImpl(ScannableTable scannableTable, UpdatableTable updatableTable, Supplier<PartitionCalculator> partitionCalculator) {
            this(scannableTable, null, updatableTable, partitionCalculator);
        }

        private ExecutableTableImpl(ScannableTable scannableTable, @Nullable ScannableTable secondaryStorageTable, UpdatableTable updatableTable, Supplier<PartitionCalculator> partitionCalculator) {
            this.scannableTable = scannableTable;
            this.secondaryStorageTable = secondaryStorageTable;
            this.updatableTable = updatableTable;
            this.partitionCalculator = partitionCalculator;
        }

        @Override
        public ScannableTable scannableTable() {
            return this.scannableTable;
        }

        @Override
        @Nullable
        public ScannableTable secondaryStorageTable() {
            return this.secondaryStorageTable;
        }

        @Override
        public UpdatableTable updatableTable() {
            return this.updatableTable;
        }

        @Override
        public TableDescriptor tableDescriptor() {
            return this.updatableTable.descriptor();
        }

        @Override
        public Supplier<PartitionCalculator> partitionCalculator() {
            return this.partitionCalculator;
        }
    }
}

