/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.deployment;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.zip.ZipInputStream;
import org.apache.ignite3.internal.deployunit.DeploymentUnit;
import org.apache.ignite3.internal.deployunit.ZipDeploymentUnit;
import org.apache.ignite3.internal.deployunit.exception.DeploymentUnitZipException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.rest.deployment.InputStreamCollector;
import org.apache.ignite3.lang.IgniteException;

public class ZipInputStreamCollector
implements InputStreamCollector {
    private static final IgniteLogger LOG = Loggers.forClass(ZipInputStreamCollector.class);
    private static final byte[] ZIP_MAGIC_HEADER = new byte[]{80, 75, 3, 4};
    private ZipInputStream zis;
    private IgniteException igniteException;

    @Override
    public void addInputStream(String filename, InputStream is) {
        InputStream result;
        if (this.zis != null || this.igniteException != null) {
            ZipInputStreamCollector.safeClose(is);
            if (this.igniteException == null) {
                this.igniteException = new DeploymentUnitZipException("Deployment unit with unzip supports only single zip file.");
            }
            return;
        }
        InputStream inputStream = result = is.markSupported() ? is : new BufferedInputStream(is);
        if (ZipInputStreamCollector.isZip(result)) {
            this.zis = new ZipInputStream(result);
        } else {
            ZipInputStreamCollector.safeClose(result);
            this.igniteException = new DeploymentUnitZipException("Only zip file is supported.");
        }
    }

    private static void safeClose(InputStream is) {
        try {
            is.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to close non-zip input stream.", (Throwable)e);
        }
    }

    private static boolean isZip(InputStream is) {
        try {
            boolean isZip = Objects.deepEquals(ZIP_MAGIC_HEADER, is.readNBytes(4));
            is.reset();
            return isZip;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.zis != null) {
            this.zis.close();
        }
    }

    @Override
    public DeploymentUnit toDeploymentUnit() {
        if (this.igniteException != null) {
            throw this.igniteException;
        }
        return new ZipDeploymentUnit(this.zis);
    }
}

