/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.configuration;

import io.micronaut.security.utils.SecurityService;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.configuration.presentation.ConfigurationPresentation;
import org.apache.ignite3.internal.rest.ResourceHolder;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.gridgain.internal.rest.SecurityContextAware;

public abstract class AbstractConfigurationController
implements ResourceHolder,
SecurityContextAware {
    private ConfigurationPresentation<String> cfgPresentation;
    private final SecurityService securityService;

    public AbstractConfigurationController(ConfigurationPresentation<String> cfgPresentation, SecurityService securityService) {
        this.cfgPresentation = cfgPresentation;
        this.securityService = securityService;
    }

    public String getConfiguration() {
        return this.secured(() -> this.cfgPresentation.represent());
    }

    public String getConfigurationByPath(String path) {
        try {
            return this.secured(() -> this.cfgPresentation.representByPath(path));
        }
        catch (IllegalArgumentException ex) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)ex);
        }
    }

    public CompletableFuture<Void> updateConfiguration(String updatedConfiguration) {
        return this.secured(() -> this.cfgPresentation.update(updatedConfiguration));
    }

    @Override
    public void cleanResources() {
        this.cfgPresentation = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }
}

