/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.cdc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Objects;
import org.apache.ignite3.internal.rest.api.cdc.Sink;
import org.apache.ignite3.internal.rest.api.cdc.Violations;
import org.apache.ignite3.internal.tostring.S;

@Schema(description="Sink status", name="SinkStatus")
public class SinkStatus {
    @Schema(description="Sink")
    private Sink sink;
    @Schema(description="Checks")
    private List<Violations> checks;

    @JsonCreator
    public SinkStatus(@JsonProperty(value="Sink") Sink sink, List<Violations> checks) {
        this.sink = sink;
        this.checks = checks;
    }

    @JsonGetter
    public Sink sink() {
        return this.sink;
    }

    @JsonGetter
    public List<Violations> checks() {
        return this.checks;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SinkStatus that = (SinkStatus)o;
        return Objects.equals(this.sink, that.sink) && Objects.equals(this.checks, that.checks);
    }

    public int hashCode() {
        return Objects.hash(this.sink, this.checks);
    }

    public String toString() {
        return S.toString(SinkStatus.class, this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Sink sink;
        private List<Violations> checks;

        public Builder sink(Sink sink) {
            this.sink = sink;
            return this;
        }

        public Builder checks(List<Violations> checks) {
            this.checks = checks;
            return this;
        }

        public SinkStatus build() {
            return new SinkStatus(this.sink, this.checks);
        }
    }
}

