/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.storage.segstore;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite3.internal.raft.storage.segstore.ReadModeIndexMemTable;
import org.apache.ignite3.internal.raft.storage.segstore.SegmentFile;
import org.jetbrains.annotations.Nullable;

class CheckpointQueue {
    private final int maxSize;
    private final Lock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition notFull = this.lock.newCondition();
    @Nullable
    private Entry head;
    @Nullable
    private volatile Entry tail;
    private int size;

    CheckpointQueue(int maxSize) {
        this.maxSize = maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(SegmentFile segmentFile, ReadModeIndexMemTable memTable) throws InterruptedException {
        Entry newEntry = new Entry(segmentFile, memTable);
        this.lock.lock();
        try {
            while (this.size == this.maxSize) {
                this.notFull.await();
            }
            Entry curTail = this.tail;
            if (curTail == null) {
                this.head = newEntry;
            } else {
                curTail.next = newEntry;
                newEntry.prev = curTail;
            }
            this.tail = newEntry;
            ++this.size;
            this.notEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    Entry peek() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.size == 0) {
                this.notEmpty.await();
            }
            Entry head = this.head;
            assert (head != null);
            Entry entry = head;
            return entry;
        }
        finally {
            this.lock.unlock();
        }
    }

    void removeHead() {
        this.lock.lock();
        try {
            Entry head = this.head;
            assert (head != null);
            Entry nextHead = head.next;
            if (nextHead == null) {
                this.tail = null;
            } else {
                nextHead.prev = null;
            }
            this.head = nextHead;
            --this.size;
            this.notFull.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    Iterator<Entry> tailIterator() {
        return new Iterator<Entry>(){
            @Nullable
            private Entry curEntry;
            {
                this.curEntry = CheckpointQueue.this.tail;
            }

            @Override
            public boolean hasNext() {
                return this.curEntry != null;
            }

            @Override
            public Entry next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Entry result = this.curEntry;
                this.curEntry = this.curEntry.prev;
                return result;
            }
        };
    }

    static class Entry {
        private final SegmentFile segmentFile;
        private final ReadModeIndexMemTable memTable;
        @Nullable
        private volatile Entry next;
        @Nullable
        private volatile Entry prev;

        Entry(SegmentFile segmentFile, ReadModeIndexMemTable memTable) {
            this.segmentFile = segmentFile;
            this.memTable = memTable;
        }

        SegmentFile segmentFile() {
            return this.segmentFile;
        }

        ReadModeIndexMemTable memTable() {
            return this.memTable;
        }
    }
}

