/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyIntervalScanRetrieveBatchReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyIntervalScanRetrieveBatchReplicaRequestBuilder;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyIntervalScanRetrieveBatchReplicaRequestSerializer;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class ReadOnlyIntervalScanRetrieveBatchReplicaRequestImpl
implements ReadOnlyIntervalScanRetrieveBatchReplicaRequest,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 16380;
    @IgniteToStringInclude
    private final int batchSize;
    @IgniteToStringInclude
    private final UUID coordinatorId;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;
    @IgniteToStringInclude
    private final HybridTimestamp lowerBoundTimestamp;
    @IgniteToStringInclude
    private final HybridTimestamp readTimestamp;
    @IgniteToStringInclude
    private final long scanId;
    @IgniteToStringInclude
    private final int tableId;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;
    @IgniteToStringInclude
    private final UUID transactionId;
    @IgniteToStringInclude
    private final boolean usePrimary;

    private ReadOnlyIntervalScanRetrieveBatchReplicaRequestImpl(int batchSize, UUID coordinatorId, ReplicationGroupIdMessage groupId, HybridTimestamp lowerBoundTimestamp, HybridTimestamp readTimestamp, long scanId, int tableId, HybridTimestamp timestamp, UUID transactionId, boolean usePrimary) {
        this.batchSize = batchSize;
        this.coordinatorId = coordinatorId;
        this.groupId = groupId;
        this.lowerBoundTimestamp = lowerBoundTimestamp;
        this.readTimestamp = readTimestamp;
        this.scanId = scanId;
        this.tableId = tableId;
        this.timestamp = timestamp;
        this.transactionId = transactionId;
        this.usePrimary = usePrimary;
    }

    @Override
    public int batchSize() {
        return this.batchSize;
    }

    @Override
    public UUID coordinatorId() {
        return this.coordinatorId;
    }

    @Override
    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    @Override
    public HybridTimestamp lowerBoundTimestamp() {
        return this.lowerBoundTimestamp;
    }

    @Override
    public HybridTimestamp readTimestamp() {
        return this.readTimestamp;
    }

    @Override
    public long scanId() {
        return this.scanId;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    @Override
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public UUID transactionId() {
        return this.transactionId;
    }

    @Override
    public boolean usePrimary() {
        return this.usePrimary;
    }

    public MessageSerializer serializer() {
        return ReadOnlyIntervalScanRetrieveBatchReplicaRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(ReadOnlyIntervalScanRetrieveBatchReplicaRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 16380;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ReadOnlyIntervalScanRetrieveBatchReplicaRequestImpl otherMessage = (ReadOnlyIntervalScanRetrieveBatchReplicaRequestImpl)other;
        return Objects.equals(this.coordinatorId, otherMessage.coordinatorId) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.lowerBoundTimestamp, otherMessage.lowerBoundTimestamp) && Objects.equals(this.readTimestamp, otherMessage.readTimestamp) && Objects.equals(this.timestamp, otherMessage.timestamp) && Objects.equals(this.transactionId, otherMessage.transactionId) && this.batchSize == otherMessage.batchSize && this.scanId == otherMessage.scanId && this.tableId == otherMessage.tableId && this.usePrimary == otherMessage.usePrimary;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.batchSize, this.scanId, this.tableId, this.usePrimary, this.coordinatorId, this.groupId, this.lowerBoundTimestamp, this.readTimestamp, this.timestamp, this.transactionId);
        return result;
    }

    @Override
    public ReadOnlyIntervalScanRetrieveBatchReplicaRequestImpl clone() {
        try {
            return (ReadOnlyIntervalScanRetrieveBatchReplicaRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ReadOnlyIntervalScanRetrieveBatchReplicaRequestBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements ReadOnlyIntervalScanRetrieveBatchReplicaRequestBuilder {
        private int batchSize;
        private UUID coordinatorId;
        private ReplicationGroupIdMessage groupId;
        private HybridTimestamp lowerBoundTimestamp;
        private HybridTimestamp readTimestamp;
        private long scanId;
        private int tableId;
        private HybridTimestamp timestamp;
        private UUID transactionId;
        private boolean usePrimary;

        private Builder() {
        }

        @Override
        public ReadOnlyIntervalScanRetrieveBatchReplicaRequestBuilder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Override
        public ReadOnlyIntervalScanRetrieveBatchReplicaRequestBuilder coordinatorId(UUID coordinatorId) {
            this.coordinatorId = coordinatorId;
            return this;
        }

        @Override
        public ReadOnlyIntervalScanRetrieveBatchReplicaRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public ReadOnlyIntervalScanRetrieveBatchReplicaRequestBuilder lowerBoundTimestamp(HybridTimestamp lowerBoundTimestamp) {
            Objects.requireNonNull(lowerBoundTimestamp, "lowerBoundTimestamp is not marked @Nullable");
            this.lowerBoundTimestamp = lowerBoundTimestamp;
            return this;
        }

        @Override
        public ReadOnlyIntervalScanRetrieveBatchReplicaRequestBuilder readTimestamp(HybridTimestamp readTimestamp) {
            Objects.requireNonNull(readTimestamp, "readTimestamp is not marked @Nullable");
            this.readTimestamp = readTimestamp;
            return this;
        }

        @Override
        public ReadOnlyIntervalScanRetrieveBatchReplicaRequestBuilder scanId(long scanId) {
            this.scanId = scanId;
            return this;
        }

        @Override
        public ReadOnlyIntervalScanRetrieveBatchReplicaRequestBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public ReadOnlyIntervalScanRetrieveBatchReplicaRequestBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public ReadOnlyIntervalScanRetrieveBatchReplicaRequestBuilder transactionId(UUID transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        @Override
        public ReadOnlyIntervalScanRetrieveBatchReplicaRequestBuilder usePrimary(boolean usePrimary) {
            this.usePrimary = usePrimary;
            return this;
        }

        @Override
        public int batchSize() {
            return this.batchSize;
        }

        @Override
        public UUID coordinatorId() {
            return this.coordinatorId;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public HybridTimestamp lowerBoundTimestamp() {
            return this.lowerBoundTimestamp;
        }

        @Override
        public HybridTimestamp readTimestamp() {
            return this.readTimestamp;
        }

        @Override
        public long scanId() {
            return this.scanId;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public UUID transactionId() {
            return this.transactionId;
        }

        @Override
        public boolean usePrimary() {
            return this.usePrimary;
        }

        @Override
        public ReadOnlyIntervalScanRetrieveBatchReplicaRequest build() {
            return new ReadOnlyIntervalScanRetrieveBatchReplicaRequestImpl(this.batchSize, this.coordinatorId, Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.lowerBoundTimestamp, "lowerBoundTimestamp is not marked @Nullable"), Objects.requireNonNull(this.readTimestamp, "readTimestamp is not marked @Nullable"), this.scanId, this.tableId, this.timestamp, this.transactionId, this.usePrimary);
        }

        @Override
        public ReadOnlyIntervalScanRetrieveBatchReplicaRequest buildDeserialized() {
            return new ReadOnlyIntervalScanRetrieveBatchReplicaRequestImpl(this.batchSize, this.coordinatorId, this.groupId, this.lowerBoundTimestamp, this.readTimestamp, this.scanId, this.tableId, this.timestamp, this.transactionId, this.usePrimary);
        }
    }
}

