/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.raft;

import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.raft.SnapshotMvDataResponse;
import org.apache.ignite3.internal.partition.replicator.network.raft.SnapshotMvDataResponseImpl;

class SnapshotMvDataResponseSerializer
implements MessageSerializer<SnapshotMvDataResponse> {
    public static final SnapshotMvDataResponseSerializer INSTANCE = new SnapshotMvDataResponseSerializer();

    private SnapshotMvDataResponseSerializer() {
    }

    @Override
    public boolean writeMessage(SnapshotMvDataResponse msg, MessageWriter writer) throws MessageMappingException {
        SnapshotMvDataResponseImpl message = (SnapshotMvDataResponseImpl)msg;
        writer.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.snapshotMvDataResponse());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeBoolean("finish", message.finish());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeList("rows", message.rows(), MessageCollectionItemType.MSG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

