/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.command;

import java.util.Map;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.command.TimedBinaryRowMessage;
import org.apache.ignite3.internal.partition.replicator.network.command.UpdateAllCommandV2;
import org.apache.ignite3.internal.partition.replicator.network.command.UpdateAllCommandV2Builder;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;

class UpdateAllCommandV2Deserializer
implements MessageDeserializer<UpdateAllCommandV2> {
    private final UpdateAllCommandV2Builder msg;

    UpdateAllCommandV2Deserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.updateAllCommandV2();
    }

    @Override
    public Class<UpdateAllCommandV2> klass() {
        return UpdateAllCommandV2.class;
    }

    @Override
    public UpdateAllCommandV2 getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.updateAllCommandV2());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                ReplicationGroupIdMessage tmp = (ReplicationGroupIdMessage)reader.readMessage("commitPartitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.commitPartitionId(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                boolean tmp = reader.readBoolean("full");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.full(tmp);
                reader.incrementState();
            }
            case 2: {
                Comparable<HybridTimestamp> tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.initiatorTime((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                Comparable<HybridTimestamp> tmp = reader.readBoxedLong("leaseStartTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.leaseStartTime((Long)tmp);
                }
                reader.incrementState();
            }
            case 4: {
                Comparable<HybridTimestamp> tmp = reader.readMap("messageRowsToUpdate", MessageCollectionItemType.UUID, MessageCollectionItemType.MSG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.messageRowsToUpdate((Map<UUID, TimedBinaryRowMessage>)((Object)tmp));
                }
                reader.incrementState();
            }
            case 5: {
                Comparable<HybridTimestamp> tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.safeTime((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 6: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 7: {
                UUID tmp = reader.readUuid("txCoordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.txCoordinatorId(tmp);
                }
                reader.incrementState();
            }
            case 8: {
                UUID tmp = reader.readUuid("txId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.txId(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(UpdateAllCommandV2.class);
    }
}

