/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.partition.replicator.ReplicaPrimacy;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyReplicaRequest;
import org.apache.ignite3.internal.placementdriver.LeasePlacementDriver;
import org.apache.ignite3.internal.placementdriver.ReplicaMeta;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.replicator.exception.PrimaryReplicaMissException;
import org.apache.ignite3.internal.replicator.message.PrimaryReplicaRequest;
import org.apache.ignite3.internal.replicator.message.ReplicaRequest;
import org.apache.ignite3.internal.replicator.message.ReplicaSafeTimeSyncRequest;

public class ReplicaPrimacyEngine {
    private final LeasePlacementDriver placementDriver;
    private final ClockService clockService;
    private final ReplicationGroupId replicationGroupId;
    private final InternalClusterNode localNode;

    public ReplicaPrimacyEngine(LeasePlacementDriver placementDriver, ClockService clockService, ReplicationGroupId replicationGroupId, InternalClusterNode localNode) {
        this.placementDriver = placementDriver;
        this.clockService = clockService;
        this.replicationGroupId = replicationGroupId;
        this.localNode = localNode;
    }

    public CompletableFuture<ReplicaPrimacy> validatePrimacy(ReplicaRequest request) {
        HybridTimestamp now = this.clockService.current();
        if (request instanceof PrimaryReplicaRequest) {
            PrimaryReplicaRequest primaryReplicaRequest = (PrimaryReplicaRequest)request;
            return this.ensureReplicaIsPrimary(primaryReplicaRequest, now);
        }
        if (request instanceof ReadOnlyReplicaRequest) {
            return this.isLocalNodePrimaryReplicaAt(now);
        }
        if (request instanceof ReplicaSafeTimeSyncRequest) {
            return this.isLocalNodePrimaryReplicaAt(now);
        }
        return CompletableFuture.completedFuture(ReplicaPrimacy.empty());
    }

    private CompletableFuture<ReplicaPrimacy> ensureReplicaIsPrimary(PrimaryReplicaRequest primaryReplicaRequest, HybridTimestamp now) {
        Long enlistmentConsistencyToken = primaryReplicaRequest.enlistmentConsistencyToken();
        Function<ReplicaMeta, ReplicaPrimacy> validateClo = primaryReplicaMeta -> this.validateReplicaPrimacy(now, (ReplicaMeta)primaryReplicaMeta, enlistmentConsistencyToken);
        ReplicaMeta meta = this.placementDriver.getCurrentPrimaryReplica(this.replicationGroupId, now);
        if (meta != null) {
            try {
                return CompletableFuture.completedFuture(validateClo.apply(meta));
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture(e);
            }
        }
        return this.placementDriver.getPrimaryReplica(this.replicationGroupId, now).thenApply(validateClo);
    }

    private ReplicaPrimacy validateReplicaPrimacy(HybridTimestamp now, ReplicaMeta primaryReplicaMeta, Long enlistmentConsistencyToken) {
        if (primaryReplicaMeta == null) {
            throw new PrimaryReplicaMissException(this.localNode.name(), null, this.localNode.id(), null, enlistmentConsistencyToken, null, null);
        }
        long currentEnlistmentConsistencyToken = primaryReplicaMeta.getStartTime().longValue();
        if (enlistmentConsistencyToken != currentEnlistmentConsistencyToken || this.clockService.before(primaryReplicaMeta.getExpirationTime(), now) || !this.isLocalPeer(primaryReplicaMeta.getLeaseholderId())) {
            throw new PrimaryReplicaMissException(this.localNode.name(), primaryReplicaMeta.getLeaseholder(), this.localNode.id(), primaryReplicaMeta.getLeaseholderId(), enlistmentConsistencyToken, currentEnlistmentConsistencyToken, null);
        }
        return ReplicaPrimacy.forPrimaryReplicaRequest(primaryReplicaMeta.getStartTime().longValue());
    }

    private CompletableFuture<ReplicaPrimacy> isLocalNodePrimaryReplicaAt(HybridTimestamp timestamp) {
        return this.placementDriver.getPrimaryReplica(this.replicationGroupId, timestamp).thenApply(primaryReplica -> ReplicaPrimacy.forIsPrimary(primaryReplica != null && this.isLocalPeer(primaryReplica.getLeaseholderId())));
    }

    private boolean isLocalPeer(UUID nodeId) {
        return this.localNode.id().equals(nodeId);
    }

    public boolean tokenStillMatchesPrimary(long suspectedEnlistmentConsistencyToken) {
        HybridTimestamp currentTime = this.clockService.current();
        ReplicaMeta meta = this.placementDriver.getCurrentPrimaryReplica(this.replicationGroupId, currentTime);
        return meta != null && this.isLocalPeer(meta.getLeaseholderId()) && this.clockService.before(currentTime, meta.getExpirationTime()) && suspectedEnlistmentConsistencyToken == meta.getStartTime().longValue();
    }
}

