/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.message;

import org.apache.ignite3.internal.network.NetworkMessagesTypeInfos;
import org.apache.ignite3.internal.network.message.ClusterNodeMessage;
import org.apache.ignite3.internal.network.message.ClusterNodeMessageImpl;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;

class ClusterNodeMessageSerializer
implements MessageSerializer<ClusterNodeMessage> {
    public static final ClusterNodeMessageSerializer INSTANCE = new ClusterNodeMessageSerializer();

    private ClusterNodeMessageSerializer() {
    }

    @Override
    public boolean writeMessage(ClusterNodeMessage msg, MessageWriter writer) throws MessageMappingException {
        ClusterNodeMessageImpl message = (ClusterNodeMessageImpl)msg;
        writer.setMessageTypeInfo(NetworkMessagesTypeInfos.clusterNodeMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)4)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeString("host", message.host());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeUuid("id", message.id());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeString("name", message.name());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeInt("port", message.port());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

