/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Objects;
import org.apache.ignite3.internal.network.message.ClassDescriptorListMessage;
import org.apache.ignite3.internal.network.message.ClassDescriptorListMessageBuilder;
import org.apache.ignite3.internal.network.message.ClassDescriptorListMessageSerializer;
import org.apache.ignite3.internal.network.message.ClassDescriptorMessage;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class ClassDescriptorListMessageImpl
implements ClassDescriptorListMessage,
Cloneable {
    public static final short GROUP_TYPE = 1;
    public static final short TYPE = 10;
    @IgniteToStringInclude
    private final Collection<ClassDescriptorMessage> messages;

    private ClassDescriptorListMessageImpl(Collection<ClassDescriptorMessage> messages) {
        this.messages = messages;
    }

    @Override
    public Collection<ClassDescriptorMessage> messages() {
        return this.messages;
    }

    public MessageSerializer serializer() {
        return ClassDescriptorListMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 1;
    }

    public String toString() {
        return S.toString(ClassDescriptorListMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 10;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClassDescriptorListMessageImpl otherMessage = (ClassDescriptorListMessageImpl)other;
        return Objects.equals(this.messages, otherMessage.messages);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.messages);
        return result;
    }

    @Override
    public ClassDescriptorListMessageImpl clone() {
        try {
            return (ClassDescriptorListMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ClassDescriptorListMessageBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.messages != null) {
            for (ClassDescriptorMessage obj : this.messages) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.messages != null) {
            for (ClassDescriptorMessage obj : this.messages) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements ClassDescriptorListMessageBuilder {
        private Collection<ClassDescriptorMessage> messages;

        private Builder() {
        }

        @Override
        public ClassDescriptorListMessageBuilder messages(Collection<ClassDescriptorMessage> messages) {
            Objects.requireNonNull(messages, "messages is not marked @Nullable");
            this.messages = messages;
            return this;
        }

        @Override
        public Collection<ClassDescriptorMessage> messages() {
            return this.messages;
        }

        @Override
        public ClassDescriptorListMessage build() {
            return new ClassDescriptorListMessageImpl(Objects.requireNonNull(this.messages, "messages is not marked @Nullable"));
        }

        @Override
        public ClassDescriptorListMessage buildDeserialized() {
            return new ClassDescriptorListMessageImpl(this.messages);
        }
    }
}

