/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.error.code.generators;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.ignite3.internal.error.code.generators.AbstractCodeGenerator;
import org.apache.ignite3.internal.error.code.processor.ErrorCodeGroupDescriptor;
import org.apache.ignite3.internal.error.code.processor.ErrorCodeGroupProcessorException;

public abstract class GenericGenerator
implements AbstractCodeGenerator {
    final ProcessingEnvironment processingEnvironment;
    final String outFilePath;
    BufferedWriter writer;
    static final int groupShift = 16;

    protected void line(String str) throws IOException {
        this.writer.write(str);
        this.writer.newLine();
    }

    protected void line() throws IOException {
        this.line("");
    }

    GenericGenerator(ProcessingEnvironment processingEnvironment, String outFilePath) {
        this.processingEnvironment = processingEnvironment;
        this.outFilePath = outFilePath;
    }

    void generateFile(List<ErrorCodeGroupDescriptor> descriptors) throws IOException, ErrorCodeGroupProcessorException {
        throw new ErrorCodeGroupProcessorException("generateFile not implemented!");
    }

    void generateLicense() throws IOException {
        this.line("/*");
        this.line(" *  Copyright (C) GridGain Systems. All Rights Reserved.");
        this.line(" *  _________        _____ __________________        _____");
        this.line(" *  __  ____/___________(_)______  /__  ____/______ ____(_)_______");
        this.line(" *  _  / __  __  ___/__  / _  __  / _  / __  _  __ `/__  / __  __ \\");
        this.line(" *  / /_/ /  _  /    _  /  / /_/ /  / /_/ /  / /_/ / _  /  _  / / /");
        this.line(" *  \\____/   /_/     /_/   \\_,__/   \\____/   \\__,_/  /_/   /_/ /_/");
        this.line(" */");
        this.line();
    }

    @Override
    public void generate(List<ErrorCodeGroupDescriptor> descriptors) {
        try {
            FileObject resource = this.processingEnvironment.getFiler().createResource(StandardLocation.NATIVE_HEADER_OUTPUT, "", this.outFilePath, new Element[0]);
            this.writer = new BufferedWriter(resource.openWriter());
            this.generateLicense();
            this.generateFile(descriptors);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new ErrorCodeGroupProcessorException("IO exception during annotation processing", e);
        }
    }
}

