/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.compute.BroadcastExecution;
import org.apache.ignite3.compute.BroadcastJobTarget;
import org.apache.ignite3.compute.IgniteCompute;
import org.apache.ignite3.compute.JobDescriptor;
import org.apache.ignite3.compute.JobExecution;
import org.apache.ignite3.compute.JobTarget;
import org.apache.ignite3.compute.TaskDescriptor;
import org.apache.ignite3.compute.task.TaskExecution;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.apache.ignite3.internal.wrapper.Wrappers;
import org.apache.ignite3.lang.CancellationToken;
import org.gridgain.internal.security.context.GridGainSecurity;
import org.gridgain.internal.security.context.SecurityContext;
import org.jetbrains.annotations.Nullable;

public class SecuredIgniteCompute
implements IgniteCompute,
Wrapper {
    private final IgniteCompute delegate;
    private final SecurityContext securityContext;

    public SecuredIgniteCompute(IgniteCompute delegate, SecurityContext securityContext) {
        this.delegate = delegate;
        this.securityContext = securityContext;
    }

    @Override
    public <T, R> CompletableFuture<JobExecution<R>> submitAsync(JobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.submitAsync(target, descriptor, arg, cancellationToken));
    }

    @Override
    public <T, R> CompletableFuture<BroadcastExecution<R>> submitAsync(BroadcastJobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.submitAsync(target, descriptor, arg, cancellationToken));
    }

    @Override
    public <T, R> R execute(JobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return (R)GridGainSecurity.getWith(this.securityContext, () -> this.delegate.execute(target, descriptor, arg, cancellationToken));
    }

    @Override
    public <T, R> Collection<R> execute(BroadcastJobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.execute(target, descriptor, arg, cancellationToken));
    }

    @Override
    public <T, R> TaskExecution<R> submitMapReduce(TaskDescriptor<T, R> taskDescriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return GridGainSecurity.getWith(this.securityContext, () -> this.delegate.submitMapReduce(taskDescriptor, arg, cancellationToken));
    }

    @Override
    public <T, R> R executeMapReduce(TaskDescriptor<T, R> taskDescriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return (R)GridGainSecurity.getWith(this.securityContext, () -> this.delegate.executeMapReduce(taskDescriptor, arg, cancellationToken));
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return Wrappers.unwrap(this.delegate, classToUnwrap);
    }
}

