/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.AbstractTableCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableDropColumnCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexColumnDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTablePolicyDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTablePolicyPredicate;
import org.apache.ignite3.internal.catalog.storage.DropColumnsEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.internal.util.CollectionUtils;

public class AlterTableDropColumnCommand
extends AbstractTableCommand {
    private final Set<String> columns;

    public static AlterTableDropColumnCommandBuilder builder() {
        return new Builder();
    }

    private AlterTableDropColumnCommand(String tableName, String schemaName, boolean ifTableExists, Set<String> columns) throws CatalogValidationException {
        super(schemaName, tableName, ifTableExists, true);
        AlterTableDropColumnCommand.validate(columns);
        this.columns = CollectionUtils.copyOrNull(columns);
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, !this.ifTableExists);
        if (schema == null) {
            return List.of();
        }
        CatalogTableDescriptor table = CatalogUtils.table(schema, this.tableName, !this.ifTableExists);
        if (table == null) {
            return List.of();
        }
        Set indexedColumns = AlterTableDropColumnCommand.aliveIndexesForTable(catalog, table.id()).flatMap(AlterTableDropColumnCommand::indexColumnNames).collect(Collectors.toSet());
        Map<String, List<String>> policiesByColumnName = AlterTableDropColumnCommand.mapPoliciesByColumnName(catalog.policies(table.id()));
        this.columns.stream().sorted().forEach(columnName -> {
            if (table.column((String)columnName) == null) {
                throw new CatalogValidationException("Column with name '{}' not found in table '{}.{}'.", columnName, this.schemaName, this.tableName);
            }
            if (table.isPrimaryKeyColumn((String)columnName)) {
                throw new CatalogValidationException("Deleting column `{}` belonging to primary key is not allowed.", columnName);
            }
            if (columnName.equals(table.expireColumn())) {
                throw new CatalogValidationException("Deleting column `{}` is not allowed because it is set as expire column", columnName);
            }
            if (columnName.equals(table.archiveColumn())) {
                throw new CatalogValidationException("Deleting column `{}` is not allowed because it is set as archive column", columnName);
            }
            if (indexedColumns.contains(columnName)) {
                List indexesNames = AlterTableDropColumnCommand.aliveIndexesForTable(catalog, table.id()).filter(index -> AlterTableDropColumnCommand.indexColumnNames(index).anyMatch(columnName::equals)).map(CatalogObjectDescriptor::name).collect(Collectors.toList());
                throw new CatalogValidationException("Deleting column '{}' used by index(es) {}, it is not allowed.", columnName, indexesNames);
            }
            List policies = (List)policiesByColumnName.get(columnName);
            if (policies != null) {
                throw new CatalogValidationException("Deleting column '{}' is not allowed, because it's used by row-level security policies '{}'.", columnName, String.join((CharSequence)", ", policies));
            }
        });
        return List.of(new DropColumnsEntry(table.id(), this.columns));
    }

    private static Map<String, List<String>> mapPoliciesByColumnName(List<CatalogTablePolicyDescriptor> policies) {
        if (policies.isEmpty()) {
            return Map.of();
        }
        HashMap<String, List<String>> policiesToColumnName = new HashMap<String, List<String>>();
        for (CatalogTablePolicyDescriptor policy : policies) {
            if (!(policy.predicate() instanceof CatalogTablePolicyPredicate.CurrentUserPolicyPredicate)) continue;
            CatalogTablePolicyPredicate.CurrentUserPolicyPredicate currentUserPredicate = (CatalogTablePolicyPredicate.CurrentUserPolicyPredicate)policy.predicate();
            policiesToColumnName.computeIfAbsent(currentUserPredicate.columnName(), v -> new ArrayList()).add(policy.name());
        }
        return policiesToColumnName;
    }

    private static Stream<CatalogIndexDescriptor> aliveIndexesForTable(Catalog catalog, int tableId) {
        return catalog.indexes(tableId).stream().filter(index -> index.status().isAlive());
    }

    private static Stream<String> indexColumnNames(CatalogIndexDescriptor index) {
        switch (index.indexType()) {
            case HASH: {
                return ((CatalogHashIndexDescriptor)index).columns().stream();
            }
            case SORTED: {
                return ((CatalogSortedIndexDescriptor)index).columns().stream().map(CatalogIndexColumnDescriptor::name);
            }
        }
        throw new AssertionError((Object)index.indexType().toString());
    }

    private static void validate(Set<String> columns) {
        if (CollectionUtils.nullOrEmpty(columns)) {
            throw new CatalogValidationException("Columns not specified.");
        }
        for (String name : columns) {
            CatalogParamsValidationUtils.validateIdentifier(name, "Name of the column");
        }
    }

    private static class Builder
    implements AlterTableDropColumnCommandBuilder {
        private Set<String> columns;
        private String schemaName;
        private String tableName;
        private boolean ifTableExists;

        private Builder() {
        }

        @Override
        public AlterTableDropColumnCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public AlterTableDropColumnCommandBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public AlterTableDropColumnCommandBuilder ifTableExists(boolean ifTableExists) {
            this.ifTableExists = ifTableExists;
            return this;
        }

        @Override
        public AlterTableDropColumnCommandBuilder columns(Set<String> columns) {
            this.columns = columns;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new AlterTableDropColumnCommand(this.tableName, this.schemaName, this.ifTableExists, this.columns);
        }
    }
}

