/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.app;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.configuration.SystemDistributedConfiguration;
import org.apache.ignite3.internal.configuration.utils.SystemDistributedConfigurationPropertyHolder;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.tostring.IgniteToStringBuilder;
import org.apache.ignite3.internal.tostring.SensitiveDataLoggingPolicy;

class SystemPropertiesComponent
implements IgniteComponent {
    private static final String SENSITIVE_DATA_LOGGING = "sensitiveDataLogging";
    private final SystemDistributedConfigurationPropertyHolder<SensitiveDataLoggingPolicy> sensitiveDataLogging;

    SystemPropertiesComponent(SystemDistributedConfiguration configuration) {
        this.sensitiveDataLogging = new SystemDistributedConfigurationPropertyHolder<SensitiveDataLoggingPolicy>(configuration, (value, revision) -> IgniteToStringBuilder.setSensitiveDataPolicy(value), SENSITIVE_DATA_LOGGING, SensitiveDataLoggingPolicy.HASH, v -> SensitiveDataLoggingPolicy.valueOf(v.toUpperCase()));
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.sensitiveDataLogging.init();
        SensitiveDataLoggingPolicy policy = this.sensitiveDataLogging.currentValue();
        IgniteToStringBuilder.setSensitiveDataPolicy(policy);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        return CompletableFuture.completedFuture(null);
    }
}

