/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.cache;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.cache.Cache;
import org.apache.ignite3.client.handler.ResponseWriter;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.table.IgniteTablesInternal;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.lang.util.IgniteNameUtils;

public class ClientCachesGetRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, IgniteTablesInternal igniteTables) {
        return igniteTables.cachesAsync().thenApply(tables -> out -> {
            out.packInt(tables.size());
            for (Cache table : tables) {
                TableViewInternal tableImpl = (TableViewInternal)table;
                out.packInt(tableImpl.tableId());
                out.packString(ClientCachesGetRequest.quoteTableNameIfNotAllUpper(table.qualifiedName().objectName()));
            }
        });
    }

    private static String quoteTableNameIfNotAllUpper(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (i > 0 && (Character.isDigit(ch) || ch == '_') || Character.isUpperCase(ch)) continue;
            return IgniteNameUtils.quote(name);
        }
        return name;
    }
}

