/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.structure;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.schema.SchemaManager;
import org.apache.ignite3.internal.table.IgniteTablesInternal;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.lang.util.IgniteNameUtils;
import org.apache.ignite3.marshalling.Marshaller;
import org.apache.ignite3.sql.IgniteSql;
import org.apache.ignite3.table.KeyValueView;
import org.apache.ignite3.table.QualifiedName;
import org.gridgain.internal.structure.StructureProcessor;
import org.gridgain.internal.structure.map.IgniteMapImpl;
import org.gridgain.internal.structure.map.MapStructureDescriptor;
import org.gridgain.structure.IgniteMap;
import org.gridgain.structure.IgniteStructures;
import org.gridgain.structure.MapConfiguration;
import org.gridgain.structure.StructureUtils;

public class GridgainStructuresComponent
implements IgniteStructures,
IgniteComponent {
    private final IgniteSql sql;
    private final StructureProcessor processor;

    public GridgainStructuresComponent(CatalogManager catalogManager, IgniteTablesInternal tables, IgniteSql sql, SchemaManager manager) {
        this.processor = new StructureProcessor(catalogManager, tables);
        this.sql = sql;
    }

    @Override
    public <K, V> CompletableFuture<IgniteMap<K, V>> getOrCreateMapAsync(MapConfiguration configuration) {
        return this.doGetOrCreateMapAsync(configuration);
    }

    @Override
    public <K, V> CompletableFuture<IgniteMap<K, V>> getOrCreateMapAsync(String name, Marshaller<K, byte[]> km, Marshaller<V, byte[]> vm) {
        return this.getOrCreateMapAsync(MapConfiguration.builder(name, km, vm).build());
    }

    @Override
    public <K, V> CompletableFuture<IgniteMap<K, V>> getOrCreateMapAsync(String name, Class<K> keyClass, Class<V> valueClass) {
        return this.getOrCreateMapAsync(MapConfiguration.builder(name, keyClass, valueClass).build());
    }

    @Override
    public <K, V> IgniteMap<K, V> getOrCreateMap(MapConfiguration configuration) {
        return GridgainStructuresComponent.sync(this.getOrCreateMapAsync(configuration));
    }

    @Override
    public <K, V> IgniteMap<K, V> getOrCreateMap(String name, Marshaller<K, byte[]> keyMarshaller, Marshaller<V, byte[]> valueMarshaller) {
        return GridgainStructuresComponent.sync(this.getOrCreateMapAsync(name, keyMarshaller, valueMarshaller));
    }

    @Override
    public <K, V> IgniteMap<K, V> getOrCreateMap(String name, Class<K> keyClass, Class<V> valueClass) {
        return GridgainStructuresComponent.sync(this.getOrCreateMapAsync(name, keyClass, valueClass));
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return null;
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        return null;
    }

    private static <R> R sync(CompletableFuture<R> future) {
        try {
            return future.join();
        }
        catch (CompletionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow(IgniteExceptionMapperUtil.mapToPublicException(ExceptionUtils.unwrapCause(e)));
        }
    }

    private <K, V> CompletableFuture<IgniteMap<K, V>> doGetOrCreateMapAsync(MapConfiguration conf) {
        MapStructureDescriptor descriptor = MapStructureDescriptor.of(conf);
        QualifiedName tableName = QualifiedName.of("SYSTEM", IgniteNameUtils.quoteIfNeeded(conf.getName().objectName()));
        return this.processor.process(descriptor).thenApply(view -> new IgniteMapImpl(tableName.toCanonicalForm(), (KeyValueView<?, ?>)view, this.sql, StructureUtils.cast(conf.getKeyMarshaller()), StructureUtils.cast(conf.getValueMarshaller())));
    }
}

