/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.sql.engine.InternalSqlRow;
import org.apache.ignite3.internal.sql.engine.prepare.copy.CopyLocationSelect;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.internal.type.NativeTypes;
import org.apache.ignite3.internal.util.AsyncCursor;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.lang.Cursor;
import org.apache.ignite3.sql.ColumnMetadata;
import org.apache.ignite3.sql.ColumnType;
import org.gridgain.internal.sql.copy.Reader;
import org.jetbrains.annotations.Nullable;

public class SelectReader
implements Reader {
    private final List<Column> columns;
    private final Cursor<InternalSqlRow> cursor;

    public SelectReader(CopyLocationSelect location, int batchSize) {
        this.columns = location.plan().metadata().columns().stream().map(meta -> new Column(meta.name(), SelectReader.toNativeType(meta), meta.nullable())).collect(Collectors.toList());
        this.cursor = new SyncCursor<InternalSqlRow>(location.cursor(), batchSize);
    }

    @Override
    public boolean hasNext() {
        return this.cursor.hasNext();
    }

    @Override
    public List<?> next() {
        return SelectReader.asList((InternalSqlRow)this.cursor.next());
    }

    @Override
    public void close() throws Exception {
        this.cursor.close();
    }

    @Override
    public List<Column> columns() {
        return this.columns;
    }

    private static List<?> asList(InternalSqlRow row) {
        int fieldCount = row.fieldCount();
        ArrayList<Object> res = new ArrayList<Object>(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            res.add(row.get(i));
        }
        return res;
    }

    @Nullable
    private static NativeType toNativeType(ColumnMetadata meta) {
        ColumnType spec = meta.type();
        if (spec == null) {
            return null;
        }
        switch (spec) {
            case BOOLEAN: {
                return NativeTypes.BOOLEAN;
            }
            case INT8: {
                return NativeTypes.INT8;
            }
            case INT16: {
                return NativeTypes.INT16;
            }
            case INT32: {
                return NativeTypes.INT32;
            }
            case INT64: {
                return NativeTypes.INT64;
            }
            case FLOAT: {
                return NativeTypes.FLOAT;
            }
            case DOUBLE: {
                return NativeTypes.DOUBLE;
            }
            case UUID: {
                return NativeTypes.UUID;
            }
            case DATE: {
                return NativeTypes.DATE;
            }
            case TIME: {
                return NativeTypes.time(meta.precision());
            }
            case DATETIME: {
                return NativeTypes.datetime(meta.precision());
            }
            case TIMESTAMP: {
                return NativeTypes.timestamp(meta.precision());
            }
            case STRING: {
                return NativeTypes.stringOf(meta.precision());
            }
            case BYTE_ARRAY: {
                return NativeTypes.blobOf(meta.precision());
            }
            case DECIMAL: {
                return NativeTypes.decimalOf(meta.precision(), meta.scale());
            }
        }
        throw new UnsupportedOperationException("Unexpected type: " + String.valueOf((Object)spec));
    }

    private static class SyncCursor<T>
    implements Cursor<T> {
        private final AsyncCursor<T> ac;
        private final Iterator<T> it;

        SyncCursor(AsyncCursor<T> ac, int batchSize) {
            this.ac = ac;
            this.it = new SyncIterator<T>(ac, batchSize);
        }

        @Override
        public void close() {
            try {
                this.ac.closeAsync().toCompletableFuture().get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw (RuntimeException)ExceptionUtils.sneakyThrow(ExceptionUtils.unwrapCause(e));
            }
            catch (ExecutionException e) {
                throw (RuntimeException)ExceptionUtils.sneakyThrow(ExceptionUtils.copyExceptionWithCause(e));
            }
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            return this.it.next();
        }
    }

    private static class SyncIterator<T>
    implements Iterator<T> {
        private final AsyncCursor<T> ac;
        private AsyncCursor.BatchedResult<T> curPage;
        private Iterator<T> curPageIt;
        private CompletableFuture<AsyncCursor.BatchedResult<T>> nextPageStage;
        private final int batchSize;

        SyncIterator(AsyncCursor<T> ac, int batchSize) {
            this.ac = ac;
            this.batchSize = batchSize;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            if (this.curPageIt.hasNext()) {
                return true;
            }
            if (this.nextPageStage != null) {
                try {
                    this.curPage = this.nextPageStage.join();
                }
                catch (CompletionException e) {
                    throw (RuntimeException)ExceptionUtils.sneakyThrow(ExceptionUtils.copyExceptionWithCause(e));
                }
                this.advance();
                return this.curPageIt.hasNext();
            }
            return false;
        }

        @Override
        public T next() {
            return this.curPageIt.next();
        }

        private void advance() {
            if (this.curPage == null) {
                this.curPage = this.ac.requestNextAsync(this.batchSize).join();
            }
            this.curPageIt = this.curPage.items().iterator();
            this.nextPageStage = this.curPage.hasMore() ? this.ac.requestNextAsync(this.batchSize) : null;
        }
    }
}

