/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.parquet;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.sql.engine.prepare.copy.CopyLocationPath;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.GroupFactory;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Types;
import org.gridgain.internal.sql.copy.Writer;
import org.gridgain.internal.sql.copy.parquet.GroupParquetWriter;
import org.gridgain.internal.sql.copy.parquet.GroupWriteSupport;
import org.gridgain.internal.sql.copy.parquet.LocalOutputFile;
import org.gridgain.internal.sql.copy.parquet.ParquetGroupSchemaUtils;
import org.gridgain.internal.sql.copy.parquet.ParquetGroupUtils;
import org.gridgain.internal.sql.copy.s3.S3ClientFactory;
import org.gridgain.internal.sql.copy.s3.S3Utils;

@Deprecated(forRemoval=true)
public class ParquetWriter
implements Writer {
    private static final Logger LOGGER = Logger.getLogger(ParquetWriter.class.getName());
    private final MessageType schema;
    private final GroupFactory groupFactory;
    private final org.apache.parquet.hadoop.ParquetWriter<Group> writer;

    public ParquetWriter(CopyLocationPath into, Map<String, String> properties, List<Column> columns) throws IOException {
        Types.MessageTypeBuilder messageTypeBuilder = Types.buildMessage();
        for (Column column : columns) {
            messageTypeBuilder.addField(ParquetGroupSchemaUtils.getParquetType(column));
        }
        this.schema = messageTypeBuilder.named("schema");
        this.groupFactory = new SimpleGroupFactory(this.schema);
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema(this.schema, conf);
        OutputFile outputFile = ParquetWriter.getOutputFile(into.path(), properties);
        try {
            this.writer = ((GroupParquetWriter.Builder)((GroupParquetWriter.Builder)GroupParquetWriter.builder(outputFile).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withConf(conf)).build();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Failed to write Parquet file: " + into.path(), e);
            throw new IOException("Failed to write Parquet file: " + into.path(), e);
        }
    }

    private static OutputFile getOutputFile(String path, Map<String, String> properties) throws IOException {
        if (S3Utils.isS3Scheme(path)) {
            return S3ClientFactory.getS3OutputFile(path, properties);
        }
        return new LocalOutputFile(Paths.get(path, new String[0]));
    }

    @Override
    public void write(List<?> item) throws IOException {
        this.writer.write((Object)this.createGroup(item));
    }

    private Group createGroup(List<?> values) {
        Group group = this.groupFactory.newGroup();
        for (int i = 0; i < this.schema.getColumns().size(); ++i) {
            ParquetGroupUtils.putValueToGroup(group, this.schema.getFieldName(i), values.get(i));
        }
        return group;
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
    }
}

