/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.parquet;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.UUID;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.Int96Value;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.gridgain.internal.sql.copy.parquet.ObjectGroup;
import org.gridgain.internal.sql.copy.parquet.ParquetTimestampUtils;
import org.gridgain.internal.sql.copy.parquet.ParquetUuidUtils;
import org.jetbrains.annotations.Nullable;

public class ParquetGroupUtils {
    public static final int DECIMAL_PRECISION = 38;
    public static final int DECIMAL_SCALE = 20;

    @Nullable
    public static Object getValueFromGroup(Type columnType, ObjectGroup group, int index) {
        if (group.getValue(index, 0) == null) {
            return null;
        }
        LogicalTypeAnnotation typeAnnotation = columnType.getLogicalTypeAnnotation();
        if (typeAnnotation instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
            return LocalDate.ofEpochDay(group.getInteger(index, 0));
        }
        if (typeAnnotation instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation) {
            int millis = group.getInteger(index, 0);
            return LocalTime.ofNanoOfDay((long)millis * 1000L * 1000L);
        }
        if (typeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
            return ParquetTimestampUtils.getTimestamp(group.getLong(index, 0), columnType.getLogicalTypeAnnotation());
        }
        if (typeAnnotation instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation) {
            return group.getString(index, 0);
        }
        if (typeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)columnType.getLogicalTypeAnnotation();
            PrimitiveType.PrimitiveTypeName primitiveTypeName = columnType.asPrimitiveType().getPrimitiveTypeName();
            switch (primitiveTypeName) {
                case INT32: {
                    return BigDecimal.valueOf(group.getInteger(index, 0), decimalAnnotation.getScale());
                }
                case INT64: {
                    return BigDecimal.valueOf(group.getLong(index, 0), decimalAnnotation.getScale());
                }
                case BINARY: 
                case FIXED_LEN_BYTE_ARRAY: {
                    return new BigDecimal(new BigInteger(group.getBinary(index, 0).getBytes()), decimalAnnotation.getScale());
                }
            }
            throw new IllegalStateException("Unexpected value: " + String.valueOf(primitiveTypeName));
        }
        if (LogicalTypeAnnotation.uuidType().equals(columnType.getLogicalTypeAnnotation())) {
            return ParquetUuidUtils.fromBinaryToUuid(group.getBinary(index, 0));
        }
        if (columnType.isPrimitive()) {
            PrimitiveType.PrimitiveTypeName primitiveTypeName = columnType.asPrimitiveType().getPrimitiveTypeName();
            switch (primitiveTypeName) {
                case INT32: {
                    return group.getInteger(index, 0);
                }
                case INT64: {
                    if (ParquetTimestampUtils.isInt64Timestamp(columnType.getLogicalTypeAnnotation())) {
                        return ParquetTimestampUtils.getTimestamp(group.getLong(index, 0), columnType.getLogicalTypeAnnotation());
                    }
                    return group.getLong(index, 0);
                }
                case FLOAT: {
                    return Float.valueOf(group.getFloat(index, 0));
                }
                case DOUBLE: {
                    return group.getDouble(index, 0);
                }
                case BOOLEAN: {
                    return group.getBoolean(index, 0);
                }
                case BINARY: {
                    return group.getBinary(index, 0).getBytes();
                }
                case INT96: {
                    Int96Value int96 = new Int96Value(group.getInt96(index, 0));
                    Instant inst = Instant.ofEpochMilli(ParquetTimestampUtils.getTimestampMillis(int96.getInt96()));
                    return LocalDateTime.ofInstant(inst, ZoneOffset.UTC);
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    return group.getBinary(index, 0);
                }
            }
            throw new IllegalStateException("Unexpected value: " + String.valueOf(primitiveTypeName));
        }
        return group.getValueToString(index, 0);
    }

    public static void putValueToGroup(Group group, String columnName, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Boolean) {
            group.add(columnName, ((Boolean)value).booleanValue());
        } else if (value instanceof Byte) {
            group.add(columnName, ((Byte)value).intValue());
        } else if (value instanceof Short) {
            group.add(columnName, ((Short)value).intValue());
        } else if (value instanceof Integer) {
            group.add(columnName, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            group.add(columnName, ((Long)value).longValue());
        } else if (value instanceof Float) {
            group.add(columnName, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            group.add(columnName, ((Double)value).doubleValue());
        } else if (value instanceof String) {
            group.add(columnName, (String)value);
        } else if (value instanceof LocalDate) {
            long epochDay = ((LocalDate)value).toEpochDay();
            group.add(columnName, Long.valueOf(epochDay).intValue());
        } else if (value instanceof LocalTime) {
            group.add(columnName, ((LocalTime)value).get(ChronoField.MILLI_OF_DAY));
        } else if (value instanceof LocalDateTime) {
            LocalDateTime val = (LocalDateTime)value;
            group.add(columnName, val.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
        } else if (value instanceof UUID) {
            group.add(columnName, ParquetUuidUtils.fromUuid((UUID)value));
        } else if (value instanceof byte[]) {
            group.add(columnName, Binary.fromConstantByteArray((byte[])((byte[])value)));
        } else if (value instanceof BigDecimal) {
            BigDecimal val = (BigDecimal)value;
            BigInteger unscaled = val.scaleByPowerOfTen(val.scale()).toBigInteger();
            group.add(columnName, Binary.fromByteArray((byte[])unscaled.toByteArray()));
        } else {
            group.add(columnName, value.toString());
        }
    }
}

