/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.csv;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVWriterBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.ICSVWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.sql.engine.prepare.copy.CopyLocationPath;
import org.gridgain.internal.sql.copy.Writer;
import org.gridgain.internal.sql.copy.s3.S3ClientFactory;
import org.gridgain.internal.sql.copy.s3.S3Utils;

public class CsvWriter
implements Writer {
    private final ICSVWriter writer;
    private final List<Column> columns;
    private final String nullstring;
    private boolean header;

    public CsvWriter(CopyLocationPath location, Map<String, String> properties, List<Column> columns) throws IOException {
        char delimiter = properties.getOrDefault("delimiter", ",").charAt(0);
        Charset charset = Charset.forName(properties.getOrDefault("charset", "UTF-8"));
        char quoteChar = properties.getOrDefault("quoteChar", "\"").charAt(0);
        char escapeChar = properties.getOrDefault("escapeChar", "\\").charAt(0);
        boolean strictQuotes = Boolean.parseBoolean(properties.getOrDefault("strictQuotes", "false"));
        boolean ignoreLeadingWhitespace = Boolean.parseBoolean(properties.getOrDefault("igniteLeadingWhitespace", "true"));
        boolean ignoreQuoations = Boolean.parseBoolean(properties.getOrDefault("ignoreQuotations", "false"));
        this.header = Boolean.parseBoolean(properties.getOrDefault("header", "false"));
        this.columns = columns;
        this.nullstring = properties.getOrDefault("null", "");
        CSVParser parser = new CSVParserBuilder().withSeparator(delimiter).withQuoteChar(quoteChar).withEscapeChar(escapeChar).withStrictQuotes(strictQuotes).withIgnoreLeadingWhiteSpace(ignoreLeadingWhitespace).withIgnoreQuotations(ignoreQuoations).build();
        this.writer = new CSVWriterBuilder(CsvWriter.getWriterForPath(location.path(), charset, properties)).withParser((ICSVParser)parser).build();
    }

    @Override
    public void write(List<?> item) throws IOException {
        if (this.header) {
            this.writer.writeNext(this.toStringLine(CsvWriter.toColumnNames(this.columns)), false);
            this.header = false;
        }
        this.writer.writeNext(this.toStringLine(item), false);
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
    }

    private static java.io.Writer getWriterForPath(String path, Charset charset, Map<String, String> properties) throws IOException {
        if (S3Utils.isS3Scheme(path)) {
            return S3ClientFactory.getOutputStreamWriter(path, properties);
        }
        return Files.newBufferedWriter(Paths.get(path, new String[0]), charset, new OpenOption[0]);
    }

    private String[] toStringLine(List<?> item) {
        String[] arr = new String[item.size()];
        for (int i = 0; i < item.size(); ++i) {
            Object column = item.get(i);
            arr[i] = column == null ? this.nullstring : column.toString();
        }
        return arr;
    }

    private static List<?> toColumnNames(List<Column> columns) {
        ArrayList<String> columnNames = new ArrayList<String>(columns.size());
        for (Column column : columns) {
            String name = column.name();
            columnNames.add(name);
        }
        return columnNames;
    }
}

