/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.coordinator;

import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metastorage.dsl.Condition;
import org.apache.ignite3.internal.metastorage.dsl.Conditions;
import org.apache.ignite3.internal.metastorage.dsl.Operations;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.gridgain.internal.snapshots.SnapshotManagerContext;
import org.gridgain.internal.snapshots.SnapshotUtils;
import org.gridgain.internal.snapshots.communication.metastorage.CreateSnapshotGlobalState;
import org.gridgain.internal.snapshots.communication.metastorage.CreateSnapshotGlobalStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.MetaStorageKeys;
import org.jetbrains.annotations.Nullable;

class SnapshotOperations {
    private static final IgniteLogger LOG = Loggers.forClass(SnapshotOperations.class);
    private static final int MAX_CAS_RETRIES = 3;
    private final SnapshotManagerContext context;

    SnapshotOperations(SnapshotManagerContext context) {
        this.context = context;
    }

    CompletableFuture<Boolean> removeFromParentSnapshotDependencies(CreateSnapshotGlobalState deletedSnapshot) {
        return this.removeFromParentSnapshotDependencies(deletedSnapshot.parentSnapshotId(), deletedSnapshot.snapshotId());
    }

    CompletableFuture<Boolean> removeFromParentSnapshotDependencies(@Nullable UUID parentSnapshotId, UUID deletedSnapshotId) {
        if (parentSnapshotId == null) {
            return CompletableFutures.trueCompletedFuture();
        }
        return this.removeFromParentSnapshotDependencies(3, parentSnapshotId, deletedSnapshotId).whenComplete((result, e) -> {
            if (e != null) {
                LOG.error("Unable to remove dependent snapshot {} from parent snapshot {}", deletedSnapshotId, parentSnapshotId, e);
                return;
            }
            if (!result.booleanValue()) {
                LOG.error("Failed to remove dependent snapshot {} from parent snapshot {} after {} retries", deletedSnapshotId, parentSnapshotId, 3);
                return;
            }
            LOG.info("Successfully removed dependent snapshot {} from parent snapshot {}", deletedSnapshotId, parentSnapshotId);
        });
    }

    private CompletableFuture<Boolean> removeFromParentSnapshotDependencies(int retriesLeft, UUID parentSnapshotId, UUID deletedSnapshotId) {
        if (retriesLeft <= 0) {
            return CompletableFutures.falseCompletedFuture();
        }
        return IgniteUtils.inBusyLock(this.context.busyLock(), () -> this.context.metaStorageManager().get(MetaStorageKeys.createSnapshotGlobalStateKey(parentSnapshotId)).thenComposeAsync(entry -> IgniteUtils.inBusyLock(this.context.busyLock(), () -> {
            if (SnapshotUtils.isMissing(entry)) {
                return CompletableFutures.trueCompletedFuture();
            }
            CreateSnapshotGlobalState parentSnapshotState = CreateSnapshotGlobalStateSerializer.deserialize(entry.value());
            if (!parentSnapshotState.dependentSnapshotIds().contains(deletedSnapshotId)) {
                return CompletableFutures.trueCompletedFuture();
            }
            HashSet<UUID> newDependentSnapshotIds = new HashSet<UUID>(parentSnapshotState.dependentSnapshotIds());
            newDependentSnapshotIds.remove(deletedSnapshotId);
            CreateSnapshotGlobalState newParentSnapshotState = new CreateSnapshotGlobalState(parentSnapshotState.operationId(), parentSnapshotState.status(), parentSnapshotState.nodeNames(), parentSnapshotState.startTime(), parentSnapshotState.tableIds(), parentSnapshotState.tableNames(), parentSnapshotState.fromTimestamp(), parentSnapshotState.timestamp(), parentSnapshotState.description(), parentSnapshotState.parentSnapshotId(), newDependentSnapshotIds, parentSnapshotState.snapshotUri(), parentSnapshotState.encryptionProviderName());
            return this.context.metaStorageManager().invoke((Condition)Conditions.value(MetaStorageKeys.createSnapshotGlobalStateKey(parentSnapshotState.snapshotId())).eq(entry.value()), List.of(Operations.put(MetaStorageKeys.createSnapshotGlobalStateKey(parentSnapshotState.snapshotId()), CreateSnapshotGlobalStateSerializer.serialize(newParentSnapshotState))), List.of()).thenComposeAsync(success -> {
                if (success.booleanValue()) {
                    return CompletableFutures.trueCompletedFuture();
                }
                return this.removeFromParentSnapshotDependencies(retriesLeft - 1, parentSnapshotId, deletedSnapshotId);
            }, (Executor)this.context.threadPool());
        }), (Executor)this.context.threadPool()));
    }
}

