/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.coordinator;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.network.ClusterNodeImpl;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.gridgain.internal.snapshots.SnapshotManagerContext;
import org.gridgain.internal.snapshots.communication.metastorage.CreateSnapshotGlobalState;
import org.gridgain.internal.snapshots.communication.metastorage.CreateSnapshotGlobalStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.MetaStorageKeys;
import org.gridgain.internal.snapshots.coordinator.CreateSnapshotLocalStateWatch;
import org.gridgain.internal.snapshots.coordinator.RecoverySubscriber;
import org.gridgain.internal.snapshots.coordinator.SnapshotCoordinatorState;

class CreateSnapshotRecoveryHandler
extends RecoverySubscriber {
    private static final IgniteLogger LOG = Loggers.forClass(CreateSnapshotRecoveryHandler.class);
    private final SnapshotCoordinatorState snapshotCoordinatorState;

    CreateSnapshotRecoveryHandler(SnapshotManagerContext context, SnapshotCoordinatorState snapshotCoordinatorState) {
        super(context);
        this.snapshotCoordinatorState = snapshotCoordinatorState;
    }

    @Override
    public void onNext(Entry entry) {
        CreateSnapshotGlobalState globalState = CreateSnapshotGlobalStateSerializer.deserialize(entry.value());
        if (this.snapshotCoordinatorState.hasOngoingSnapshotOperation(globalState.snapshotId())) {
            return;
        }
        switch (globalState.status()) {
            case COMPLETED: 
            case FAILED: {
                break;
            }
            case STARTED: {
                this.recoverOngoingSnapshot(globalState);
                break;
            }
            default: {
                LOG.error("Unexpected Snapshot Status: {}", new Object[]{globalState.status()});
            }
        }
    }

    private void recoverOngoingSnapshot(CreateSnapshotGlobalState globalState) {
        LOG.info("Starting Snapshot recovery for Snapshot {}, current state: {}", globalState.snapshotId(), globalState);
        Catalog catalog = this.context.catalogManager().activeCatalog(globalState.timestamp().longValue());
        List<CatalogTableDescriptor> tableDescriptors = globalState.tableIds().stream().map(catalog::table).collect(Collectors.toList());
        this.snapshotCoordinatorState.rebalanceWatch().addOperation(globalState.snapshotId(), tableDescriptors);
        CreateSnapshotLocalStateWatch localStateWatch = new CreateSnapshotLocalStateWatch(this.context, this.snapshotCoordinatorState, globalState);
        ((CompletableFuture)this.context.logicalTopologyService().logicalTopologyOnLeader().thenComposeAsync(topology -> {
            Set topologyNodes = topology.nodes().stream().map(ClusterNodeImpl::name).collect(Collectors.toSet());
            Set<String> missingNodes = CollectionUtils.difference(globalState.nodeNames(), topologyNodes);
            if (!missingNodes.isEmpty()) {
                LOG.info("Nodes {} are no longer present in the topology, cancelling Snapshot {}", missingNodes, globalState.snapshotId());
                String errorMessage = "Some nodes are missing from the topology: " + String.valueOf(missingNodes);
                return localStateWatch.onSnapshotFailed(this.context.nodeName(), errorMessage);
            }
            return this.continueSnapshotCreation(globalState, localStateWatch);
        }, (Executor)this.context.threadPool())).whenComplete((v, e) -> {
            if (e == null) {
                LOG.info("Recovery complete for Snapshot Operation {}.", globalState.snapshotId());
            } else {
                String errorMessage = String.format("Error when performing recovery for Snapshot Operation %s: %s", globalState.snapshotId(), e.getMessage());
                LOG.error(errorMessage, (Throwable)e);
                localStateWatch.onSnapshotFailed(this.context.nodeName(), errorMessage);
            }
        });
    }

    private CompletableFuture<Void> continueSnapshotCreation(CreateSnapshotGlobalState globalState, CreateSnapshotLocalStateWatch localStateWatch) {
        ByteArray prefix = MetaStorageKeys.createSnapshotLocalStatePrefix(globalState.snapshotId());
        this.context.metaStorageManager().registerPrefixWatch(prefix, localStateWatch);
        return this.replayEvents(localStateWatch, prefix);
    }
}

