/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.communication.messages;

import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.gridgain.internal.snapshots.communication.messages.DeleteSnapshotMessage;
import org.gridgain.internal.snapshots.communication.messages.DeleteSnapshotMessageBuilder;
import org.gridgain.internal.snapshots.communication.messages.SnapshotMessagesFactory;
import org.gridgain.internal.snapshots.communication.messages.SnapshotMessagesTypeInfos;

class DeleteSnapshotMessageDeserializer
implements MessageDeserializer<DeleteSnapshotMessage> {
    private final DeleteSnapshotMessageBuilder msg;

    DeleteSnapshotMessageDeserializer(SnapshotMessagesFactory messageFactory) {
        this.msg = messageFactory.deleteSnapshotMessage();
    }

    @Override
    public Class<DeleteSnapshotMessage> klass() {
        return DeleteSnapshotMessage.class;
    }

    @Override
    public DeleteSnapshotMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(SnapshotMessagesTypeInfos.deleteSnapshotMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                UUID tmp = reader.readUuid("targetSnapshotId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.targetSnapshotId(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(DeleteSnapshotMessage.class);
    }
}

