/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.metastorage.impl.MetaStorageManagerImpl;
import org.apache.ignite3.internal.metastorage.impl.MetaStorageServiceImpl;
import org.apache.ignite3.internal.network.ClusterService;
import org.apache.ignite3.internal.network.NetworkMessage;
import org.apache.ignite3.internal.raft.Peer;
import org.apache.ignite3.internal.rest.api.snapshot.SnapshotOperation;
import org.apache.ignite3.internal.rest.api.snapshot.SnapshotOperationType;
import org.apache.ignite3.internal.rest.api.snapshot.SnapshotType;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.subscription.Accumulator;
import org.apache.ignite3.internal.util.subscription.ListAccumulator;
import org.apache.ignite3.table.QualifiedName;
import org.gridgain.internal.encryption.EncryptionManager;
import org.gridgain.internal.snapshots.SnapshotDecryptionProviderNotFoundException;
import org.gridgain.internal.snapshots.SnapshotEncryptionProviderNotFoundException;
import org.gridgain.internal.snapshots.SnapshotException;
import org.gridgain.internal.snapshots.SnapshotFacade;
import org.gridgain.internal.snapshots.SnapshotOperationNotFoundException;
import org.gridgain.internal.snapshots.communication.messages.CreateSnapshotMessage;
import org.gridgain.internal.snapshots.communication.messages.DeleteSnapshotMessage;
import org.gridgain.internal.snapshots.communication.messages.ErrorResponseMessage;
import org.gridgain.internal.snapshots.communication.messages.NotCoordinatorMessage;
import org.gridgain.internal.snapshots.communication.messages.RestoreSnapshotMessage;
import org.gridgain.internal.snapshots.communication.messages.SnapshotMessagesFactory;
import org.gridgain.internal.snapshots.communication.messages.SuccessResponseMessage;
import org.gridgain.internal.snapshots.communication.metastorage.CreateSnapshotGlobalState;
import org.gridgain.internal.snapshots.communication.metastorage.CreateSnapshotGlobalStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.DeleteSnapshotGlobalState;
import org.gridgain.internal.snapshots.communication.metastorage.DeleteSnapshotGlobalStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.GlobalSnapshotState;
import org.gridgain.internal.snapshots.communication.metastorage.LocalSnapshotState;
import org.gridgain.internal.snapshots.communication.metastorage.LocalSnapshotStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.OperationType;
import org.gridgain.internal.snapshots.communication.metastorage.RestoreSnapshotGlobalState;
import org.gridgain.internal.snapshots.communication.metastorage.RestoreSnapshotGlobalStateSerializer;
import org.jetbrains.annotations.Nullable;

public class SnapshotFacadeImpl
implements SnapshotFacade {
    private final ClusterService clusterService;
    private final MetaStorageManagerImpl metaStorageManager;
    private final SnapshotMessagesFactory messagesFactory = new SnapshotMessagesFactory();
    private final EncryptionManager encryptionManager;

    public SnapshotFacadeImpl(ClusterService clusterService, MetaStorageManagerImpl metaStorageManager, EncryptionManager encryptionManager) {
        this.clusterService = clusterService;
        this.metaStorageManager = metaStorageManager;
        this.encryptionManager = encryptionManager;
    }

    @Override
    public CompletableFuture<UUID> createSnapshot(SnapshotType snapshotType, Set<String> tableNames, @Nullable String destination, @Nullable Instant timestamp, @Nullable String encryptionProvider) {
        if (encryptionProvider != null && !this.encryptionManager.hasProvider(encryptionProvider)) {
            throw new SnapshotEncryptionProviderNotFoundException(encryptionProvider);
        }
        long hybridTimestampLong = timestamp == null ? 0L : HybridTimestamp.physicalToLong(timestamp.toEpochMilli());
        CreateSnapshotMessage createSnapshotMessage = this.messagesFactory.createSnapshotMessage().snapshotTypeOrdinal(snapshotType.ordinal()).tableNames(tableNames).timestampLong(hybridTimestampLong).destination(destination).encryptionProviderName(encryptionProvider).build();
        return this.sendToSnapshotCoordinator(createSnapshotMessage);
    }

    @Override
    public CompletableFuture<UUID> restoreSnapshot(UUID targetSnapshotId, Set<String> tableNames, @Nullable String source, @Nullable String decryptionProvider) {
        if (decryptionProvider != null && !this.encryptionManager.hasProvider(decryptionProvider)) {
            throw new SnapshotDecryptionProviderNotFoundException(decryptionProvider);
        }
        RestoreSnapshotMessage restoreSnapshotMessage = this.messagesFactory.restoreSnapshotMessage().targetSnapshotId(targetSnapshotId).tableNames(tableNames).source(source).encryptionProviderName(decryptionProvider).build();
        return this.sendToSnapshotCoordinator(restoreSnapshotMessage);
    }

    @Override
    public CompletableFuture<UUID> deleteSnapshot(UUID targetSnapshotId) {
        DeleteSnapshotMessage deleteSnapshotMessage = this.messagesFactory.deleteSnapshotMessage().targetSnapshotId(targetSnapshotId).build();
        return this.sendToSnapshotCoordinator(deleteSnapshotMessage);
    }

    @Override
    public CompletableFuture<List<SnapshotOperation>> getSnapshotOperationsList() {
        CompletableFuture createOperations = this.getOperationsByType(OperationType.CREATE);
        CompletableFuture restoreOperations = this.getOperationsByType(OperationType.RESTORE);
        CompletableFuture deleteOperations = this.getOperationsByType(OperationType.DELETE);
        return SnapshotFacadeImpl.combineFutureLists(createOperations, restoreOperations, deleteOperations).thenApply(operations -> {
            Map<UUID, SnapshotOperation> uuidToOperationMap = SnapshotFacadeImpl.createUuidToOperationMapping(operations);
            Map<SnapshotOperation, SnapshotOperationDependencies> depsTree = SnapshotFacadeImpl.createDependenciesMapping(operations);
            for (SnapshotOperation operation : operations) {
                UUID parentSnapshotId = operation.operation() == SnapshotOperationType.CREATE ? operation.parentSnapshotId() : operation.targetSnapshotId();
                SnapshotOperation parentSnapshot = uuidToOperationMap.get(parentSnapshotId);
                if (parentSnapshot == null) continue;
                SnapshotOperationDependencies parentDeps = depsTree.get(parentSnapshot);
                SnapshotOperationDependencies childDeps = depsTree.get(operation);
                parentDeps.add(childDeps);
            }
            List roots = operations.stream().filter(op -> ((SnapshotOperationDependencies)depsTree.get((Object)op)).parent == null).sorted(Comparator.comparingLong(SnapshotOperation::startTimeEpochMilli).reversed()).collect(Collectors.toList());
            ArrayList<SnapshotOperation> result = new ArrayList<SnapshotOperation>(operations.size());
            for (SnapshotOperation root : roots) {
                result.add(root);
                depsTree.get(root).appendChildrenToList(result);
            }
            return result;
        });
    }

    private static Map<UUID, SnapshotOperation> createUuidToOperationMapping(List<SnapshotOperation> operations) {
        return operations.stream().collect(Collectors.toMap(SnapshotOperation::operationId, Function.identity()));
    }

    private static Map<SnapshotOperation, SnapshotOperationDependencies> createDependenciesMapping(List<SnapshotOperation> operations) {
        return operations.stream().collect(Collectors.toMap(Function.identity(), SnapshotOperationDependencies::new));
    }

    @Override
    public CompletableFuture<List<SnapshotOperation>> getOperationById(UUID operationId, boolean allNodes) {
        CompletableFuture createOperations = this.getOperations(operationId, allNodes, OperationType.CREATE);
        CompletableFuture restoreOperations = this.getOperations(operationId, allNodes, OperationType.RESTORE);
        CompletableFuture deleteOperations = this.getOperations(operationId, allNodes, OperationType.DELETE);
        return SnapshotFacadeImpl.combineFutureLists(createOperations, restoreOperations, deleteOperations).thenApply(operations -> {
            if (operations.isEmpty()) {
                throw new SnapshotOperationNotFoundException(operationId);
            }
            return operations;
        });
    }

    private CompletableFuture<List<SnapshotOperation>> getOperations(UUID operationId, boolean allNodes, OperationType operation) {
        ByteArray globalKey = operation.metastorageGlobalKey(operationId);
        CompletableFuture<Entry> globalEntry = this.metaStorageManager.get(globalKey);
        if (!allNodes) {
            return globalEntry.thenApply(entry -> {
                SnapshotOperation snapshotOperation = SnapshotFacadeImpl.getGlobalSnapshotOperation(entry, operation);
                return snapshotOperation == null ? List.of() : List.of(snapshotOperation);
            });
        }
        return globalEntry.thenCompose(entry -> this.retrieveLocalStatesInfo((Entry)entry, operationId, operation));
    }

    private CompletableFuture<List<SnapshotOperation>> getOperationsByType(OperationType operation) {
        CompletableFuture<List<SnapshotOperation>> result = new CompletableFuture<List<SnapshotOperation>>();
        ListAccumulator<Entry, SnapshotOperation> accumulator = new ListAccumulator<Entry, SnapshotOperation>(entry -> SnapshotFacadeImpl.getGlobalSnapshotOperation(entry, operation));
        Flow.Publisher<Entry> cursor = this.metaStorageManager.prefix(operation.metastorageGlobalPrefix());
        cursor.subscribe(accumulator.toSubscriber(result));
        return result;
    }

    private CompletableFuture<List<SnapshotOperation>> retrieveLocalStatesInfo(Entry globalEntry, UUID operationId, final OperationType operation) {
        final SnapshotOperation globalOperation = SnapshotFacadeImpl.getGlobalSnapshotOperation(globalEntry, operation);
        if (globalOperation == null) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        CompletableFuture localEntries = new CompletableFuture();
        final ArrayList<SnapshotOperation> result = new ArrayList<SnapshotOperation>();
        result.add(globalOperation);
        Accumulator<Entry, List<SnapshotOperation>> accumulator = new Accumulator<Entry, List<SnapshotOperation>>(){

            @Override
            public void accumulate(Entry item) {
                result.add(SnapshotFacadeImpl.getLocalSnapshotOperation(globalOperation, item, operation));
            }

            @Override
            public List<SnapshotOperation> get() {
                return result;
            }
        };
        Flow.Publisher<Entry> cursorLocal = this.metaStorageManager.prefix(operation.metastorageLocalPrefix(operationId));
        cursorLocal.subscribe(accumulator.toSubscriber(localEntries));
        return localEntries.thenApply(entries -> result);
    }

    @Nullable
    private static SnapshotOperation getGlobalSnapshotOperation(Entry entry, OperationType operation) {
        UUID parentSnapshotId;
        Long timestamp;
        UUID targetSnapshotId;
        GlobalSnapshotState state;
        if (entry.value() == null) {
            return null;
        }
        switch (operation) {
            case CREATE: {
                CreateSnapshotGlobalState createState = CreateSnapshotGlobalStateSerializer.deserialize(entry.value());
                state = createState;
                targetSnapshotId = null;
                timestamp = createState.timestamp().getPhysical();
                parentSnapshotId = createState.parentSnapshotId();
                break;
            }
            case RESTORE: {
                RestoreSnapshotGlobalState restoreState = RestoreSnapshotGlobalStateSerializer.deserialize(entry.value());
                state = restoreState;
                targetSnapshotId = restoreState.targetSnapshotId();
                parentSnapshotId = null;
                timestamp = null;
                break;
            }
            case DELETE: {
                DeleteSnapshotGlobalState deleteState = DeleteSnapshotGlobalStateSerializer.deserialize(entry.value());
                state = deleteState;
                targetSnapshotId = deleteState.targetSnapshotId();
                parentSnapshotId = null;
                timestamp = null;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected operation type: " + String.valueOf((Object)operation));
            }
        }
        return new SnapshotOperation(state.operationId(), state.status().name(), operation.name(), state.startTime().toEpochMilli(), timestamp, targetSnapshotId, parentSnapshotId, CollectionUtils.mapToImmutableSet(state.tableNames(), QualifiedName::toCanonicalForm), state.description(), null, null, state.snapshotUri().uri(), state.snapshotUri().type().name());
    }

    private static SnapshotOperation getLocalSnapshotOperation(SnapshotOperation globalOperation, Entry localStateEntry, OperationType operation) {
        LocalSnapshotState local = LocalSnapshotStateSerializer.deserialize(localStateEntry.value());
        String nodeName = operation.nodeName(localStateEntry.key());
        return new SnapshotOperation(globalOperation.operationId(), local.status().name(), globalOperation.operation().name(), globalOperation.startTimeEpochMilli(), globalOperation.timestampEpochMilli(), globalOperation.targetSnapshotId(), globalOperation.parentSnapshotId(), globalOperation.tableNames(), local.errorMessage(), nodeName, local.numRows(), globalOperation.uri(), globalOperation.pathType().name());
    }

    private static <T> CompletableFuture<List<T>> combineFutureLists(CompletableFuture<List<T>> first, CompletableFuture<List<T>> second, CompletableFuture<List<T>> third) {
        return CompletableFutures.allOfToList(first, second, third).thenApply(lists -> {
            ArrayList result = new ArrayList(((List)lists.get(0)).size() + ((List)lists.get(1)).size() + ((List)lists.get(2)).size());
            result.addAll((Collection)lists.get(0));
            result.addAll((Collection)lists.get(1));
            result.addAll((Collection)lists.get(2));
            return result;
        });
    }

    private CompletableFuture<UUID> sendToSnapshotCoordinator(NetworkMessage message) {
        return ((CompletableFuture)this.metaStorageManager.metaStorageService().thenApply(MetaStorageServiceImpl::raftGroupService)).thenCompose(msRaftService -> {
            Peer leader = msRaftService.leader();
            if (leader == null) {
                return msRaftService.refreshLeader().thenCompose(v -> this.sendToSnapshotCoordinator(message));
            }
            return ((CompletableFuture)this.clusterService.messagingService().invoke(leader.consistentId(), message, 10000L).exceptionally(e -> {
                throw new SnapshotException("Unable to start snapshot operation: " + e.getMessage(), (Throwable)e);
            })).thenCompose(response -> {
                if (response instanceof SuccessResponseMessage) {
                    return CompletableFuture.completedFuture(((SuccessResponseMessage)response).operationId());
                }
                if (response instanceof NotCoordinatorMessage) {
                    return msRaftService.refreshLeader().thenCompose(v -> this.sendToSnapshotCoordinator(message));
                }
                if (response instanceof ErrorResponseMessage) {
                    return CompletableFuture.failedFuture(((ErrorResponseMessage)response).error());
                }
                return CompletableFuture.failedFuture((Throwable)((Object)new AssertionError((Object)"Unexpected response type")));
            });
        });
    }

    private static class SnapshotOperationDependencies {
        @Nullable
        SnapshotOperationDependencies parent;
        final SnapshotOperation operation;
        final SortedSet<SnapshotOperationDependencies> children = new TreeSet<SnapshotOperationDependencies>(Comparator.comparingLong(d -> d.operation.startTimeEpochMilli()));

        SnapshotOperationDependencies(SnapshotOperation operation) {
            this.operation = operation;
        }

        void add(SnapshotOperationDependencies child) {
            child.parent = this;
            this.children.add(child);
        }

        void appendChildrenToList(List<SnapshotOperation> list) {
            for (SnapshotOperationDependencies child : this.children) {
                list.add(child.operation);
                child.appendChildrenToList(list);
            }
        }
    }
}

