/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.metastorage.dsl.Condition;
import org.apache.ignite3.internal.metastorage.dsl.Conditions;
import org.apache.ignite3.internal.metastorage.dsl.Operations;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.gridgain.internal.snapshots.AbstractGlobalStateWatch;
import org.gridgain.internal.snapshots.DataKeyGenerator;
import org.gridgain.internal.snapshots.SnapshotCancelledException;
import org.gridgain.internal.snapshots.SnapshotContext;
import org.gridgain.internal.snapshots.SnapshotManagerContext;
import org.gridgain.internal.snapshots.SnapshotWriter;
import org.gridgain.internal.snapshots.communication.metastorage.CreateSnapshotGlobalState;
import org.gridgain.internal.snapshots.communication.metastorage.CreateSnapshotGlobalStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.LocalSnapshotState;
import org.gridgain.internal.snapshots.communication.metastorage.LocalSnapshotStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.MetaStorageKeys;
import org.gridgain.internal.snapshots.communication.metastorage.SnapshotStatus;
import org.jetbrains.annotations.Nullable;

class CreateSnapshotGlobalStateWatch
extends AbstractGlobalStateWatch {
    private static final IgniteLogger LOG = Loggers.forClass(CreateSnapshotGlobalStateWatch.class);
    private final SnapshotWriter snapshotWriter;

    CreateSnapshotGlobalStateWatch(SnapshotManagerContext context) {
        super(context);
        this.snapshotWriter = new SnapshotWriter(context);
    }

    @Override
    void processNewStateEntry(Entry entry) {
        this.context.threadPool().execute(() -> {
            CreateSnapshotGlobalState globalState = CreateSnapshotGlobalStateSerializer.deserialize(entry.value());
            if (globalState.status() == SnapshotStatus.STARTED) {
                if (!globalState.nodeNames().contains(this.context.nodeName())) {
                    LOG.info("Received a snapshot request, but the node is not in the list of target nodes, skipping.", new Object[0]);
                    return;
                }
                LOG.info("Starting local snapshot creation, snapshotId = {}.", globalState.snapshotId());
                this.startSnapshotCreation(globalState, entry.revision());
            } else if (globalState.status() == SnapshotStatus.FAILED) {
                LOG.info("Creation of snapshot {} failed, removing created data.", globalState.snapshotId());
                this.cancelSnapshotCreation(globalState);
            }
        });
    }

    private void startSnapshotCreation(CreateSnapshotGlobalState globalState, long causalityToken) {
        this.createDekIfRequired(globalState);
        SnapshotContext<CreateSnapshotGlobalState> snapshotContext = new SnapshotContext<CreateSnapshotGlobalState>(globalState, this.context.snapshotFileSystemManager().snapshotFileSystem(globalState.snapshotId(), globalState.snapshotUri()), this.context.busyLock(), causalityToken);
        if (!this.context.ongoingSnapshots().registerSnapshotOperation(snapshotContext)) {
            LOG.info("Skipping snapshot creation, because the node is stopping", new Object[0]);
            return;
        }
        CompletionStage createSnapshotFuture = this.initializeLocalState(snapshotContext).thenCompose(v -> this.snapshotWriter.createSnapshot(snapshotContext));
        ((CompletableFuture)createSnapshotFuture).whenComplete((v, e) -> {
            try {
                this.unlockTombstoneLowWatermarkIfIncremental(snapshotContext);
            }
            catch (Throwable ex) {
                LOG.error("Unable to unlock tombstone low watermark", ex);
            }
        });
        ((CompletableFuture)((CompletableFuture)createSnapshotFuture).handle((numRows, e) -> this.finalizeLocalState(snapshotContext, (Long)numRows, (Throwable)e))).whenComplete((v, e) -> snapshotContext.complete());
    }

    private void createDekIfRequired(CreateSnapshotGlobalState globalState) {
        String encryptionProviderName = globalState.encryptionProviderName();
        if (encryptionProviderName != null) {
            this.context.keyManager().createKeyChain(globalState.snapshotId().toString(), DataKeyGenerator.create(0), encryptionProviderName);
        }
    }

    private CompletableFuture<Void> initializeLocalState(SnapshotContext<CreateSnapshotGlobalState> snapshotContext) {
        return snapshotContext.inBusyLockAsync(() -> {
            ByteArray localStateKey = MetaStorageKeys.createSnapshotLocalStateKey(((CreateSnapshotGlobalState)snapshotContext.snapshotState()).snapshotId(), this.context.nodeName());
            LocalSnapshotState localState = new LocalSnapshotState(SnapshotStatus.STARTED, 0L);
            byte[] stateAsBytes = LocalSnapshotStateSerializer.serialize(localState);
            return this.context.metaStorageManager().put(localStateKey, stateAsBytes).whenComplete((v, e) -> {
                if (e != null) {
                    LOG.error("Unable to initialize local snapshot state", (Throwable)e);
                }
            });
        });
    }

    private CompletableFuture<Boolean> finalizeLocalState(SnapshotContext<CreateSnapshotGlobalState> snapshotContext, @Nullable Long numRows, @Nullable Throwable e) {
        return IgniteUtils.inBusyLockAsync(this.context.busyLock(), () -> {
            byte[] finalState;
            UUID snapshotId = ((CreateSnapshotGlobalState)snapshotContext.snapshotState()).snapshotId();
            if (e == null) {
                LOG.info("Data for Snapshot {} has been successfully saved.", snapshotId);
                assert (numRows != null);
                finalState = LocalSnapshotStateSerializer.serialize(new LocalSnapshotState(SnapshotStatus.COMPLETED, numRows));
            } else {
                Throwable unwrapped = ExceptionUtils.unwrapCause(e);
                if (unwrapped instanceof SnapshotCancelledException) {
                    LOG.info("Snapshot {} has been cancelled.", snapshotId);
                } else {
                    LOG.error("Error when creating Snapshot {}.", e, snapshotId);
                }
                if (snapshotContext.isCancelledByCoordinator()) {
                    return CompletableFutures.nullCompletedFuture();
                }
                LocalSnapshotState state = new LocalSnapshotState(SnapshotStatus.FAILED, 0L, CreateSnapshotGlobalStateWatch.formatErrorMessage(unwrapped));
                finalState = LocalSnapshotStateSerializer.serialize(state);
            }
            ByteArray localStateKey = MetaStorageKeys.createSnapshotLocalStateKey(snapshotId, this.context.nodeName());
            CompletableFuture<Boolean> invokeFuture = this.context.metaStorageManager().invoke((Condition)Conditions.exists(localStateKey), List.of(Operations.put(localStateKey, finalState)), List.of());
            return invokeFuture.whenComplete((v, e2) -> {
                if (e2 != null) {
                    LOG.error("Unable to finalize local snapshot state", (Throwable)e2);
                }
            });
        });
    }

    private static String formatErrorMessage(Throwable e) {
        return String.format("%s: %s", e.getClass(), e.getMessage());
    }

    private void cancelSnapshotCreation(CreateSnapshotGlobalState globalState) {
        this.context.ongoingSnapshots().cancelSnapshotOperationDueToRemoteFailure(globalState.operationId()).whenCompleteAsync((v, e) -> {
            this.context.snapshotFileSystemManager().snapshotFileSystem(globalState.snapshotId(), globalState.snapshotUri()).delete();
            if (!this.context.busyLock().enterBusy()) {
                LOG.debug("Skipping removal of local snapshot state, because the node is stopping", new Object[0]);
                return;
            }
            try {
                ByteArray localStateKey = MetaStorageKeys.createSnapshotLocalStateKey(globalState.snapshotId(), this.context.nodeName());
                this.context.metaStorageManager().remove(localStateKey);
            }
            finally {
                this.context.busyLock().leaveBusy();
            }
        }, (Executor)this.context.threadPool());
    }

    private void unlockTombstoneLowWatermarkIfIncremental(SnapshotContext<CreateSnapshotGlobalState> snapshotContext) {
        CreateSnapshotGlobalState state = snapshotContext.snapshotState();
        if (state.parentSnapshotId() != null) {
            this.context.snapshotTombstoneManager().removeOngoingIncrementalSnapshot(state.snapshotId());
        }
    }
}

