/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.key.store;

import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.vault.VaultEntry;
import org.apache.ignite3.internal.vault.VaultManager;
import org.gridgain.internal.security.key.store.PrivateKeyRecord;
import org.gridgain.internal.security.key.store.serde.PrivateKeyRecordSerDe;
import org.jetbrains.annotations.Nullable;

public class PrivateKeyStore {
    private static final ByteArray JWT_SECRET_KEY_VAULT_KEY = ByteArray.fromString("gg9.security.jwt.sk");
    private final VaultManager vaultManager;

    public PrivateKeyStore(VaultManager vaultManager) {
        this.vaultManager = vaultManager;
    }

    @Nullable
    public PrivateKeyRecord getPrivateKey() {
        VaultEntry entry = this.vaultManager.get(JWT_SECRET_KEY_VAULT_KEY);
        return entry == null ? null : PrivateKeyRecordSerDe.deserialize(entry.value());
    }

    public void putPrivateKey(PrivateKeyRecord record) {
        this.vaultManager.put(JWT_SECRET_KEY_VAULT_KEY, PrivateKeyRecordSerDe.serialize(record));
    }
}

