/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rest.rbac.role;

import io.micronaut.http.annotation.Controller;
import io.micronaut.security.utils.SecurityService;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.rest.ResourceHolder;
import org.apache.ignite3.internal.rest.api.rbac.role.RoleDto;
import org.apache.ignite3.internal.rest.api.rbac.role.RoleManagementApi;
import org.gridgain.internal.rbac.roles.Role;
import org.gridgain.internal.rbac.roles.RoleManagement;
import org.gridgain.internal.rest.SecurityContextAware;

@Controller(value="/management/v1/rbac/roles")
public class RoleManagementController
implements RoleManagementApi,
ResourceHolder,
SecurityContextAware {
    private RoleManagement roleManagement;
    private final SecurityService securityService;

    public RoleManagementController(RoleManagement roleManagement, SecurityService securityService) {
        this.roleManagement = roleManagement;
        this.securityService = securityService;
    }

    private static RoleDto toDto(Role role) {
        return new RoleDto(role.name());
    }

    private static <U> Iterable<RoleDto> toDto(Collection<Role> roles) {
        return roles.stream().filter(Objects::nonNull).map(RoleManagementController::toDto).collect(Collectors.toList());
    }

    private static Role toRole(RoleDto role) {
        return Role.builder().name(role.roleName()).build();
    }

    @Override
    public CompletableFuture<Iterable<RoleDto>> roles() {
        return this.secured(() -> this.roleManagement.findAllAsync().thenApply(RoleManagementController::toDto));
    }

    @Override
    public CompletableFuture<RoleDto> role(String roleName) {
        return this.secured(() -> this.roleManagement.findByNameAsync(roleName).thenApply(RoleManagementController::toDto));
    }

    @Override
    public CompletableFuture<Void> create(RoleDto role) {
        return this.secured(() -> this.roleManagement.createAsync(RoleManagementController.toRole(role)));
    }

    @Override
    public CompletableFuture<Void> delete(String roleName, boolean revoke) {
        return this.secured(() -> this.roleManagement.dropAsync(roleName, revoke));
    }

    @Override
    public void cleanResources() {
        this.roleManagement = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }
}

