/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.recovery;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.hlc.HybridTimestampTracker;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.tx.InternalTxOptions;
import org.apache.ignite3.internal.tx.TxManager;
import org.apache.ignite3.lang.ErrorGroups;
import org.gridgain.internal.recovery.TooOldTransactionException;
import org.jetbrains.annotations.Nullable;

public class RecoveryTransactions {
    private final TxManager txManager;

    public RecoveryTransactions(TxManager txManager) {
        this.txManager = txManager;
    }

    public <T> CompletableFuture<T> runInReadOnlyTransaction(HybridTimestamp readTimestamp, Function<InternalTransaction, CompletableFuture<T>> action) {
        InternalTransaction transaction = this.startTransaction(readTimestamp);
        try {
            return ((CompletableFuture)action.apply(transaction).handle((v, e) -> RecoveryTransactions.commitTransaction(transaction, v, e))).thenCompose(Function.identity());
        }
        catch (Throwable e2) {
            return RecoveryTransactions.commitTransaction(transaction, null, e2);
        }
    }

    private InternalTransaction startTransaction(HybridTimestamp readTimestamp) {
        try {
            return this.txManager.beginExplicitRo(HybridTimestampTracker.EMPTY_TS_PROVIDER, InternalTxOptions.builder().readTimestamp(readTimestamp).timeoutMillis(Long.MAX_VALUE).build());
        }
        catch (IgniteInternalException e) {
            if (e.code() == ErrorGroups.Transactions.TX_READ_ONLY_TOO_OLD_ERR) {
                throw new TooOldTransactionException(readTimestamp);
            }
            throw e;
        }
    }

    private static <T> CompletableFuture<T> commitTransaction(InternalTransaction tx, @Nullable T result, @Nullable Throwable e) {
        return ((CompletableFuture)tx.commitAsync().handle((v, e2) -> {
            if (e != null) {
                if (e2 != null) {
                    e.addSuppressed((Throwable)e2);
                }
                return CompletableFuture.failedFuture(e);
            }
            if (e2 != null) {
                return CompletableFuture.failedFuture(e2);
            }
            return CompletableFuture.completedFuture(result);
        })).thenCompose(Function.identity());
    }
}

