/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.ignite3.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite3.internal.cluster.management.events.BeforeStartRaftGroupEventParameters;
import org.apache.ignite3.internal.cluster.management.events.ClusterManagerGroupEvent;
import org.apache.ignite3.internal.configuration.SuperRoot;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.util.ByteUtils;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.vault.VaultEntry;
import org.apache.ignite3.internal.vault.VaultManager;
import org.gridgain.internal.encryption.EncryptionConfig;
import org.gridgain.internal.encryption.EncryptionManagerImpl;
import org.gridgain.internal.encryption.configuration.EncryptionConfiguration;
import org.gridgain.internal.encryption.configuration.EncryptionView;
import org.jetbrains.annotations.Nullable;

public class EncryptionConfigurationVault
implements IgniteComponent {
    private static final ByteArray CMG_ENCRYPTION_VAULT_KEY = ByteArray.fromString("cmg_encryption_cfg");
    private final EncryptionManagerImpl encryptionManager;
    private final VaultManager vaultManager;
    private final Supplier<SuperRoot> clusterCfgSuperRootFactory;
    private final ClusterManagementGroupManager cmgMgr;
    private final IgniteComponent logStorageFactory;
    private final EncryptionConfiguration encryptionConfiguration;

    public EncryptionConfigurationVault(EncryptionManagerImpl encryptionManager, VaultManager vaultManager, Supplier<SuperRoot> clusterCfgSuperRootFactory, ClusterManagementGroupManager cmgMgr, IgniteComponent logStorageFactory, EncryptionConfiguration encryptionConfiguration) {
        this.encryptionManager = encryptionManager;
        this.vaultManager = vaultManager;
        this.clusterCfgSuperRootFactory = clusterCfgSuperRootFactory;
        this.cmgMgr = cmgMgr;
        this.logStorageFactory = logStorageFactory;
        this.encryptionConfiguration = encryptionConfiguration;
    }

    private void init(@Nullable String initialClusterConfig) {
        if (initialClusterConfig == null) {
            EncryptionConfig encryptionConfig = this.loadEncryptionConfig();
            if (encryptionConfig != null) {
                this.initEncryptionConfigOnRecovery(encryptionConfig);
            }
        } else {
            this.initEncryptionConfig(initialClusterConfig);
        }
    }

    private void registerConfigListener() {
        this.encryptionConfiguration.listen(ctx -> {
            EncryptionView encryptionView = ctx.newValue(EncryptionView.class);
            assert (encryptionView != null);
            this.saveEncryptionConfig(encryptionView);
            return CompletableFutures.nullCompletedFuture();
        });
    }

    private void initEncryptionConfig(String hoconConfig) {
        EncryptionConfig config = EncryptionConfig.fromHoconString(hoconConfig, this.clusterCfgSuperRootFactory);
        this.encryptionManager.init(config.encryptionView());
        this.saveEncryptionConfig(config);
    }

    private void initEncryptionConfigOnRecovery(EncryptionConfig config) {
        this.encryptionManager.initOnRecovery(config.encryptionView());
    }

    public void saveCurrentEncryptionConfig() {
        this.saveEncryptionConfig((EncryptionView)this.encryptionConfiguration.value());
    }

    private void saveEncryptionConfig(EncryptionView config) {
        this.saveEncryptionConfig(EncryptionConfig.fromConfig(config));
    }

    private void saveEncryptionConfig(EncryptionConfig config) {
        byte[] data = ByteUtils.stringToBytes(config.toHoconString());
        this.vaultManager.put(CMG_ENCRYPTION_VAULT_KEY, data);
    }

    @Nullable
    private EncryptionConfig loadEncryptionConfig() {
        VaultEntry entry = this.vaultManager.get(CMG_ENCRYPTION_VAULT_KEY);
        if (entry == null) {
            return null;
        }
        String hoconString = ByteUtils.stringFromBytes(entry.value());
        return EncryptionConfig.fromHoconString(hoconString, this.clusterCfgSuperRootFactory);
    }

    private void clearState() {
        this.vaultManager.remove(CMG_ENCRYPTION_VAULT_KEY);
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.registerConfigListener();
        this.cmgMgr.listen(ClusterManagerGroupEvent.BEFORE_START_RAFT_GROUP, evt -> {
            BeforeStartRaftGroupEventParameters params = (BeforeStartRaftGroupEventParameters)evt;
            try {
                this.init(params.initialClusterConfig());
            }
            catch (RuntimeException ex) {
                return CompletableFuture.failedFuture(ex);
            }
            return this.logStorageFactory.startAsync(componentContext).thenApply(none -> false);
        });
        this.cmgMgr.listen(ClusterManagerGroupEvent.BEFORE_DESTROY_RAFT_GROUP, none -> {
            this.clearState();
            return CompletableFutures.falseCompletedFuture();
        });
        this.cmgMgr.listen(ClusterManagerGroupEvent.AFTER_STOP_RAFT_GROUP, none -> this.logStorageFactory.stopAsync(componentContext).thenApply(other -> false));
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        return CompletableFutures.nullCompletedFuture();
    }
}

