/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dcr.metastorage;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gridgain.internal.dcr.ReplicationStatus;
import org.gridgain.internal.dcr.metastorage.MetaStoreDecoder;
import org.jetbrains.annotations.Nullable;

class MetaStoreByteArrayReader {
    private final MetaStoreDecoder decoder = new MetaStoreDecoder();
    private final String[] splits;
    private int iterator = 0;

    public MetaStoreByteArrayReader(byte[] byteArray) {
        String content = new String(byteArray, StandardCharsets.UTF_8);
        this.splits = content.split(";", -1);
    }

    public int readInt() {
        return Integer.parseInt(this.splits[this.iterator++]);
    }

    public long readLong() {
        return Long.parseLong(this.splits[this.iterator++]);
    }

    public String readString() {
        return this.decoder.decodeString(this.splits[this.iterator++]);
    }

    @Nullable
    public String readNullableString() {
        return this.decoder.decodeNullableString(this.splits[this.iterator++]);
    }

    public <R> R readCollection(Collector<String, ?, R> collector) {
        String collectionString = this.splits[this.iterator++];
        return this.parseCollection(collectionString, collector);
    }

    @Nullable
    public <R> R readNullableCollection(Collector<String, ?, R> collector) {
        String collectionString;
        if ((collectionString = this.splits[this.iterator++]).isEmpty()) {
            return null;
        }
        return this.parseCollection(collectionString, collector);
    }

    @Nullable
    public Map<String, ReplicationStatus> readNullableMap() {
        String mapString;
        if ((mapString = this.splits[this.iterator++]).isEmpty()) {
            return null;
        }
        return this.parseMap(mapString);
    }

    public byte[] readByteArray() {
        return this.decoder.decodeByteArray(this.splits[this.iterator++]);
    }

    public boolean hasNext() {
        return this.iterator < this.splits.length;
    }

    private <R> R parseCollection(String collectionString, Collector<String, ?, R> collector) {
        if (collectionString.isEmpty()) {
            return Stream.empty().collect(collector);
        }
        String[] collectionElements = collectionString.split(":", -1);
        return Arrays.stream(collectionElements).map(this.decoder::decodeString).collect(collector);
    }

    private Map<String, ReplicationStatus> parseMap(String mapString) {
        if (mapString.isEmpty()) {
            return Collections.emptyMap();
        }
        String[] mapElements = mapString.split(":", -1);
        return Arrays.stream(mapElements).map(element -> element.split("@", -1)).collect(Collectors.toMap(s -> this.decoder.decodeString(s[0]), s -> ReplicationStatus.values()[Integer.parseInt(s[1])]));
    }
}

