/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.snapshot.status;

import java.util.UUID;
import org.gridgain.internal.cli.call.snapshot.SnapshotStatusCallInput;
import picocli.CommandLine;

class SnapshotStatusMixin {
    @CommandLine.Option(names={"--id"}, description={"ID of the operation"})
    private UUID operationId;
    @CommandLine.Option(names={"--all-nodes"}, description={"Optional flag that modifies the output to contain every status of all nodes that participate in the snapshot operation"})
    private boolean allNodes;
    @CommandLine.Option(names={"--show-tables"}, description={"Optional flag that modifies the output to contain table names that participate in snapshot creation or restoration"})
    private boolean showTables;

    SnapshotStatusMixin() {
    }

    SnapshotStatusCallInput buildCallInput(CommandLine commandLine, String clusterUrl) {
        if (this.allNodes && this.operationId == null) {
            throw new CommandLine.ParameterException(commandLine, "Operation ID is required with --all-nodes option");
        }
        return SnapshotStatusCallInput.builder().clusterUrl(clusterUrl).allNodes(this.allNodes).showTables(this.showTables).operationId(this.operationId).build();
    }
}

