/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.license;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.LicenseManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.gridgain.internal.cli.call.license.UpdateLicenseCallInput;

@Singleton
public class UpdateLicenseCall
implements Call<UpdateLicenseCallInput, String> {
    private final ApiClientFactory apiClientFactory;

    public UpdateLicenseCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<String> execute(UpdateLicenseCallInput input) {
        String clusterUrl = input.clusterUrl();
        try {
            new LicenseManagementApi(this.apiClientFactory.getClient(clusterUrl)).applyNewLicenseRaw(input.license());
            return DefaultCallOutput.success("License was updated successfully");
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }
}

