/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.dcr;

import jakarta.inject.Singleton;
import java.time.ZoneOffset;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.DcrApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.FlushRequest;
import org.gridgain.internal.cli.call.dcr.FlushReplicationCallInput;

@Singleton
public class FlushReplicationCall
implements Call<FlushReplicationCallInput, String> {
    private final ApiClientFactory apiClientFactory;

    public FlushReplicationCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<String> execute(FlushReplicationCallInput input) {
        String clusterUrl = input.clusterUrl();
        try {
            boolean success = new DcrApi(this.apiClientFactory.getClient(clusterUrl)).flushReplication(input.replicationName(), new FlushRequest().flushPoint(input.flushPoint().atOffset(ZoneOffset.UTC)));
            if (success) {
                return DefaultCallOutput.success("Replication " + input.replicationName() + " flushed successfully.");
            }
            return DefaultCallOutput.failure(new IgniteCliException("Replication " + input.replicationName() + " was not flushed."));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }
}

