/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cdc.core.replication;

import org.gridgain.internal.cdc.api.replication.CdcReplicationDefinition;
import org.gridgain.internal.cdc.api.replication.CdcReplicationExecNodes;
import org.gridgain.internal.cdc.api.replication.CdcReplicationInstance;
import org.gridgain.internal.cdc.api.replication.CdcReplicationMode;
import org.gridgain.internal.cdc.api.replication.CdcReplicationStatus;

public class CdcReplicationInstanceValue {
    private String sinkName;
    private String sourceName;
    private CdcReplicationMode mode;
    private CdcReplicationExecNodes executionNodes = CdcReplicationExecNodes.any();
    private CdcReplicationStatus status;

    public CdcReplicationInstanceValue() {
    }

    private CdcReplicationInstanceValue(String sinkName, String sourceName, CdcReplicationMode mode, CdcReplicationExecNodes executionNodes, CdcReplicationStatus status) {
        this.sinkName = sinkName;
        this.sourceName = sourceName;
        this.mode = mode;
        this.executionNodes = executionNodes;
        this.status = status;
    }

    public String sinkName() {
        return this.sinkName;
    }

    public String sourceName() {
        return this.sourceName;
    }

    public CdcReplicationMode mode() {
        return this.mode;
    }

    public CdcReplicationExecNodes executionNodes() {
        return this.executionNodes;
    }

    public CdcReplicationStatus status() {
        return this.status;
    }

    public static CdcReplicationInstanceValue from(CdcReplicationInstance instance) {
        return new CdcReplicationInstanceValue(instance.sinkName(), instance.sourceName(), instance.mode(), instance.executionNodes(), instance.status());
    }

    public static CdcReplicationInstanceValue from(CdcReplicationDefinition definition) {
        return new CdcReplicationInstanceValue(definition.sinkName(), definition.sourceName(), definition.mode(), definition.executionNodes(), CdcReplicationStatus.CREATED);
    }

    public CdcReplicationInstance toReplicationInstance(String replicationName) {
        return CdcReplicationInstance.builder().name(replicationName).sinkName(this.sinkName).sourceName(this.sourceName).mode(this.mode).executionNodes(this.executionNodes).status(this.status).build();
    }
}

