/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cdc.core.replication;

import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.mapper.TypeConverter;
import org.gridgain.internal.cdc.api.replication.CdcReplicationExecNodes;
import org.gridgain.internal.cdc.api.replication.CdcReplicationInstance;
import org.gridgain.internal.cdc.api.replication.CdcReplicationMode;
import org.gridgain.internal.cdc.api.replication.CdcReplicationStatus;
import org.gridgain.internal.cdc.core.converters.JsonConverter;
import org.gridgain.internal.cdc.core.replication.CdcReplicationInstanceValue;

public class CdcReplicationInstanceMappings {
    public static final String REPLICATION_NAME_COL = "NAME";
    public static final String REPLICATION_STATUS_COL = "STATUS";
    public static final String REPLICATION_MODE_COL = "MODE";
    public static final String REPLICATION_SINK_NAME_COL = "SINK_NAME";
    public static final String REPLICATION_SOURCE_NAME_COL = "SOURCE_NAME";
    public static final String REPLICATION_EXECUTION_NODES_COL = "EXECUTION_NODES";

    public static Mapper<CdcReplicationInstanceValue> valueMapper() {
        return Mapper.builder(CdcReplicationInstanceValue.class).map("sinkName", REPLICATION_SINK_NAME_COL, new String[0]).map("sourceName", REPLICATION_SOURCE_NAME_COL, new String[0]).map("mode", REPLICATION_MODE_COL, new String[0]).map("status", REPLICATION_STATUS_COL, new String[0]).map("executionNodes", REPLICATION_EXECUTION_NODES_COL, new String[0]).convert("mode", new ReplicationModeConverter()).convert(REPLICATION_EXECUTION_NODES_COL, new JsonConverter<CdcReplicationExecNodes>(CdcReplicationExecNodes.class)).convert("status", new ReplicationStatusConverter()).build();
    }

    public static Mapper<CdcReplicationInstance> recordMapper() {
        return Mapper.builder(CdcReplicationInstance.class).map("name", REPLICATION_NAME_COL, new String[0]).map("status", REPLICATION_STATUS_COL, new String[0]).map("sinkName", REPLICATION_SINK_NAME_COL, new String[0]).map("sourceName", REPLICATION_SOURCE_NAME_COL, new String[0]).map("mode", REPLICATION_MODE_COL, new String[0]).map("executionNodes", REPLICATION_EXECUTION_NODES_COL, new String[0]).convert("mode", new ReplicationModeConverter()).convert(REPLICATION_EXECUTION_NODES_COL, new JsonConverter<CdcReplicationExecNodes>(CdcReplicationExecNodes.class)).convert("status", new ReplicationStatusConverter()).build();
    }

    private static class ReplicationModeConverter
    implements TypeConverter<CdcReplicationMode, Short> {
        private ReplicationModeConverter() {
        }

        @Override
        public Short toColumnType(CdcReplicationMode obj) throws Exception {
            switch (obj) {
                case ALL: {
                    return (short)0;
                }
                case NEW_DATA: {
                    return (short)1;
                }
            }
            throw new IllegalArgumentException("Unknown ReplicationMode: " + String.valueOf((Object)obj));
        }

        @Override
        public CdcReplicationMode toObjectType(Short data) throws Exception {
            switch (data) {
                case 0: {
                    return CdcReplicationMode.ALL;
                }
                case 1: {
                    return CdcReplicationMode.NEW_DATA;
                }
            }
            throw new IllegalArgumentException("Unknown ReplicationMode code: " + data);
        }
    }

    private static class ReplicationStatusConverter
    implements TypeConverter<CdcReplicationStatus, Short> {
        private ReplicationStatusConverter() {
        }

        @Override
        public Short toColumnType(CdcReplicationStatus obj) throws Exception {
            switch (obj) {
                case CREATED: {
                    return (short)0;
                }
                case RUNNING: {
                    return (short)1;
                }
                case STOPPED: {
                    return (short)2;
                }
                case FAILED: {
                    return (short)3;
                }
            }
            throw new IllegalArgumentException("Unknown ReplicationStatus: " + String.valueOf((Object)obj));
        }

        @Override
        public CdcReplicationStatus toObjectType(Short data) throws Exception {
            switch (data) {
                case 0: {
                    return CdcReplicationStatus.CREATED;
                }
                case 1: {
                    return CdcReplicationStatus.RUNNING;
                }
                case 2: {
                    return CdcReplicationStatus.STOPPED;
                }
                case 3: {
                    return CdcReplicationStatus.FAILED;
                }
            }
            throw new IllegalArgumentException("Unknown ReplicationStatus code: " + data);
        }
    }
}

