/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cdc.core;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.gridgain.internal.cdc.api.CdcManager;
import org.gridgain.internal.cdc.api.replication.CdcReplicationDefinition;
import org.gridgain.internal.cdc.api.replication.CdcReplicationInstance;
import org.gridgain.internal.cdc.api.sink.SinkDefinition;
import org.gridgain.internal.cdc.api.sink.SinkStatus;
import org.gridgain.internal.cdc.api.source.SourceDefinition;
import org.gridgain.internal.cdc.api.source.SourceStatus;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;

public class LicensedCdcManager
implements CdcManager {
    private final LicenseFeatureChecker checker;
    private final CdcManager delegate;

    public LicensedCdcManager(LicenseFeatureChecker checker, CdcManager delegate) {
        this.checker = checker;
        this.delegate = delegate;
    }

    private CompletableFuture<Void> checkLicense() {
        try {
            this.checker.checkFeature(LicenseFeature.ICEBERG_CDC);
            return CompletableFutures.nullCompletedFuture();
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Override
    public CompletableFuture<Void> createSource(SourceDefinition sourceDefinition) {
        return this.checkLicense().thenCompose(unused -> this.delegate.createSource(sourceDefinition));
    }

    @Override
    public CompletableFuture<Void> deleteSource(String sourceName) {
        return this.checkLicense().thenCompose(unused -> this.delegate.deleteSource(sourceName));
    }

    @Override
    public CompletableFuture<SourceDefinition> getSource(String sourceName) {
        return this.checkLicense().thenCompose(unused -> this.delegate.getSource(sourceName));
    }

    @Override
    public CompletableFuture<Collection<SourceDefinition>> listSources() {
        return this.checkLicense().thenCompose(unused -> this.delegate.listSources());
    }

    @Override
    public CompletableFuture<Void> updateSource(SourceDefinition source) {
        return this.checkLicense().thenCompose(unused -> this.delegate.updateSource(source));
    }

    @Override
    public CompletableFuture<SourceStatus> getSourceStatus(String name) {
        return this.checkLicense().thenCompose(unused -> this.delegate.getSourceStatus(name));
    }

    @Override
    public CompletableFuture<Void> createSink(SinkDefinition sinkDefinition) {
        return this.checkLicense().thenCompose(unused -> this.delegate.createSink(sinkDefinition));
    }

    @Override
    public CompletableFuture<Void> deleteSink(String sinkName) {
        return this.checkLicense().thenCompose(unused -> this.delegate.deleteSink(sinkName));
    }

    @Override
    public CompletableFuture<SinkDefinition> getSink(String sinkName) {
        return this.checkLicense().thenCompose(unused -> this.delegate.getSink(sinkName));
    }

    @Override
    public CompletableFuture<Collection<SinkDefinition>> listSinks() {
        return this.checkLicense().thenCompose(unused -> this.delegate.listSinks());
    }

    @Override
    public CompletableFuture<Void> updateSink(SinkDefinition sink) {
        return this.checkLicense().thenCompose(unused -> this.delegate.updateSink(sink));
    }

    @Override
    public CompletableFuture<SinkStatus> getSinkStatus(String name) {
        return this.checkLicense().thenCompose(unused -> this.delegate.getSinkStatus(name));
    }

    @Override
    public CompletableFuture<CdcReplicationInstance> createReplication(CdcReplicationDefinition replicationDefinition) {
        return this.checkLicense().thenCompose(unused -> this.delegate.createReplication(replicationDefinition));
    }

    @Override
    public CompletableFuture<Void> deleteReplication(String replicationName) {
        return this.checkLicense().thenCompose(unused -> this.delegate.deleteReplication(replicationName));
    }

    @Override
    public CompletableFuture<CdcReplicationInstance> getReplication(String replicationName) {
        return this.checkLicense().thenCompose(unused -> this.delegate.getReplication(replicationName));
    }

    @Override
    public CompletableFuture<Collection<CdcReplicationInstance>> listReplications() {
        return this.checkLicense().thenCompose(unused -> this.delegate.listReplications());
    }

    @Override
    public CompletableFuture<CdcReplicationInstance> startReplication(String replicationName) {
        return this.checkLicense().thenCompose(unused -> this.delegate.startReplication(replicationName));
    }

    @Override
    public CompletableFuture<CdcReplicationInstance> stopReplication(String replicationName) {
        return this.checkLicense().thenCompose(unused -> this.delegate.stopReplication(replicationName));
    }
}

