/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import okhttp3.Call;
import org.apache.ignite3.rest.client.invoker.ApiCallback;
import org.apache.ignite3.rest.client.invoker.ApiClient;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.invoker.ApiResponse;
import org.apache.ignite3.rest.client.invoker.Configuration;
import org.apache.ignite3.rest.client.invoker.Pair;
import org.apache.ignite3.rest.client.model.GlobalPartitionStatesResponse;
import org.apache.ignite3.rest.client.model.GlobalZonePartitionStatesResponse;
import org.apache.ignite3.rest.client.model.LocalPartitionStatesResponse;
import org.apache.ignite3.rest.client.model.LocalZonePartitionStatesResponse;
import org.apache.ignite3.rest.client.model.MigrateRequest;
import org.apache.ignite3.rest.client.model.ResetClusterRequest;
import org.apache.ignite3.rest.client.model.ResetPartitionsRequest;
import org.apache.ignite3.rest.client.model.ResetZonePartitionsRequest;
import org.apache.ignite3.rest.client.model.RestartPartitionsRequest;
import org.apache.ignite3.rest.client.model.RestartZonePartitionsRequest;
import org.apache.ignite3.rest.client.model.TablesRecoveryRequest;
import org.apache.ignite3.rest.client.model.TablesRecoveryResponse;
import org.apache.ignite3.rest.client.model.TablesRecoveryStateResponse;

public class RecoveryApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public RecoveryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RecoveryApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getGlobalPartitionStatesCall(List<String> zoneNames, List<Integer> partitionIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/recovery/state/global";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zoneNames != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "zoneNames", zoneNames));
        }
        if (partitionIds != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "partitionIds", partitionIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGlobalPartitionStatesValidateBeforeCall(List<String> zoneNames, List<Integer> partitionIds, ApiCallback _callback) throws ApiException {
        return this.getGlobalPartitionStatesCall(zoneNames, partitionIds, _callback);
    }

    public GlobalPartitionStatesResponse getGlobalPartitionStates(List<String> zoneNames, List<Integer> partitionIds) throws ApiException {
        ApiResponse<GlobalPartitionStatesResponse> localVarResp = this.getGlobalPartitionStatesWithHttpInfo(zoneNames, partitionIds);
        return localVarResp.getData();
    }

    public ApiResponse<GlobalPartitionStatesResponse> getGlobalPartitionStatesWithHttpInfo(List<String> zoneNames, List<Integer> partitionIds) throws ApiException {
        Call localVarCall = this.getGlobalPartitionStatesValidateBeforeCall(zoneNames, partitionIds, null);
        Type localVarReturnType = new TypeToken<GlobalPartitionStatesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getGlobalPartitionStatesAsync(List<String> zoneNames, List<Integer> partitionIds, ApiCallback<GlobalPartitionStatesResponse> _callback) throws ApiException {
        Call localVarCall = this.getGlobalPartitionStatesValidateBeforeCall(zoneNames, partitionIds, _callback);
        Type localVarReturnType = new TypeToken<GlobalPartitionStatesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getLocalPartitionStatesCall(List<String> zoneNames, List<String> nodeNames, List<Integer> partitionIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/recovery/state/local";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zoneNames != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "zoneNames", zoneNames));
        }
        if (nodeNames != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "nodeNames", nodeNames));
        }
        if (partitionIds != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "partitionIds", partitionIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLocalPartitionStatesValidateBeforeCall(List<String> zoneNames, List<String> nodeNames, List<Integer> partitionIds, ApiCallback _callback) throws ApiException {
        return this.getLocalPartitionStatesCall(zoneNames, nodeNames, partitionIds, _callback);
    }

    public LocalPartitionStatesResponse getLocalPartitionStates(List<String> zoneNames, List<String> nodeNames, List<Integer> partitionIds) throws ApiException {
        ApiResponse<LocalPartitionStatesResponse> localVarResp = this.getLocalPartitionStatesWithHttpInfo(zoneNames, nodeNames, partitionIds);
        return localVarResp.getData();
    }

    public ApiResponse<LocalPartitionStatesResponse> getLocalPartitionStatesWithHttpInfo(List<String> zoneNames, List<String> nodeNames, List<Integer> partitionIds) throws ApiException {
        Call localVarCall = this.getLocalPartitionStatesValidateBeforeCall(zoneNames, nodeNames, partitionIds, null);
        Type localVarReturnType = new TypeToken<LocalPartitionStatesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getLocalPartitionStatesAsync(List<String> zoneNames, List<String> nodeNames, List<Integer> partitionIds, ApiCallback<LocalPartitionStatesResponse> _callback) throws ApiException {
        Call localVarCall = this.getLocalPartitionStatesValidateBeforeCall(zoneNames, nodeNames, partitionIds, _callback);
        Type localVarReturnType = new TypeToken<LocalPartitionStatesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTablesRecoveryStateCall(UUID operationId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/recovery/tables/state/{operationId}".replace("{operationId}", this.localVarApiClient.escapeString(operationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTablesRecoveryStateValidateBeforeCall(UUID operationId, ApiCallback _callback) throws ApiException {
        if (operationId == null) {
            throw new ApiException("Missing the required parameter 'operationId' when calling getTablesRecoveryState(Async)");
        }
        return this.getTablesRecoveryStateCall(operationId, _callback);
    }

    public TablesRecoveryStateResponse getTablesRecoveryState(UUID operationId) throws ApiException {
        ApiResponse<TablesRecoveryStateResponse> localVarResp = this.getTablesRecoveryStateWithHttpInfo(operationId);
        return localVarResp.getData();
    }

    public ApiResponse<TablesRecoveryStateResponse> getTablesRecoveryStateWithHttpInfo(UUID operationId) throws ApiException {
        Call localVarCall = this.getTablesRecoveryStateValidateBeforeCall(operationId, null);
        Type localVarReturnType = new TypeToken<TablesRecoveryStateResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTablesRecoveryStateAsync(UUID operationId, ApiCallback<TablesRecoveryStateResponse> _callback) throws ApiException {
        Call localVarCall = this.getTablesRecoveryStateValidateBeforeCall(operationId, _callback);
        Type localVarReturnType = new TypeToken<TablesRecoveryStateResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getZoneGlobalPartitionStatesCall(List<String> zoneNames, List<Integer> partitionIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/recovery/zone/state/global";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zoneNames != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "zoneNames", zoneNames));
        }
        if (partitionIds != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "partitionIds", partitionIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getZoneGlobalPartitionStatesValidateBeforeCall(List<String> zoneNames, List<Integer> partitionIds, ApiCallback _callback) throws ApiException {
        return this.getZoneGlobalPartitionStatesCall(zoneNames, partitionIds, _callback);
    }

    public GlobalZonePartitionStatesResponse getZoneGlobalPartitionStates(List<String> zoneNames, List<Integer> partitionIds) throws ApiException {
        ApiResponse<GlobalZonePartitionStatesResponse> localVarResp = this.getZoneGlobalPartitionStatesWithHttpInfo(zoneNames, partitionIds);
        return localVarResp.getData();
    }

    public ApiResponse<GlobalZonePartitionStatesResponse> getZoneGlobalPartitionStatesWithHttpInfo(List<String> zoneNames, List<Integer> partitionIds) throws ApiException {
        Call localVarCall = this.getZoneGlobalPartitionStatesValidateBeforeCall(zoneNames, partitionIds, null);
        Type localVarReturnType = new TypeToken<GlobalZonePartitionStatesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getZoneGlobalPartitionStatesAsync(List<String> zoneNames, List<Integer> partitionIds, ApiCallback<GlobalZonePartitionStatesResponse> _callback) throws ApiException {
        Call localVarCall = this.getZoneGlobalPartitionStatesValidateBeforeCall(zoneNames, partitionIds, _callback);
        Type localVarReturnType = new TypeToken<GlobalZonePartitionStatesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getZoneLocalPartitionStatesCall(List<String> zoneNames, List<String> nodeNames, List<Integer> partitionIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/recovery/zone/state/local";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zoneNames != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "zoneNames", zoneNames));
        }
        if (nodeNames != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "nodeNames", nodeNames));
        }
        if (partitionIds != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "partitionIds", partitionIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getZoneLocalPartitionStatesValidateBeforeCall(List<String> zoneNames, List<String> nodeNames, List<Integer> partitionIds, ApiCallback _callback) throws ApiException {
        return this.getZoneLocalPartitionStatesCall(zoneNames, nodeNames, partitionIds, _callback);
    }

    public LocalZonePartitionStatesResponse getZoneLocalPartitionStates(List<String> zoneNames, List<String> nodeNames, List<Integer> partitionIds) throws ApiException {
        ApiResponse<LocalZonePartitionStatesResponse> localVarResp = this.getZoneLocalPartitionStatesWithHttpInfo(zoneNames, nodeNames, partitionIds);
        return localVarResp.getData();
    }

    public ApiResponse<LocalZonePartitionStatesResponse> getZoneLocalPartitionStatesWithHttpInfo(List<String> zoneNames, List<String> nodeNames, List<Integer> partitionIds) throws ApiException {
        Call localVarCall = this.getZoneLocalPartitionStatesValidateBeforeCall(zoneNames, nodeNames, partitionIds, null);
        Type localVarReturnType = new TypeToken<LocalZonePartitionStatesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getZoneLocalPartitionStatesAsync(List<String> zoneNames, List<String> nodeNames, List<Integer> partitionIds, ApiCallback<LocalZonePartitionStatesResponse> _callback) throws ApiException {
        Call localVarCall = this.getZoneLocalPartitionStatesValidateBeforeCall(zoneNames, nodeNames, partitionIds, _callback);
        Type localVarReturnType = new TypeToken<LocalZonePartitionStatesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call migrateCall(MigrateRequest migrateRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        MigrateRequest localVarPostBody = migrateRequest;
        String localVarPath = "/management/v1/recovery/cluster/migrate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call migrateValidateBeforeCall(MigrateRequest migrateRequest, ApiCallback _callback) throws ApiException {
        if (migrateRequest == null) {
            throw new ApiException("Missing the required parameter 'migrateRequest' when calling migrate(Async)");
        }
        return this.migrateCall(migrateRequest, _callback);
    }

    public void migrate(MigrateRequest migrateRequest) throws ApiException {
        this.migrateWithHttpInfo(migrateRequest);
    }

    public ApiResponse<Void> migrateWithHttpInfo(MigrateRequest migrateRequest) throws ApiException {
        Call localVarCall = this.migrateValidateBeforeCall(migrateRequest, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call migrateAsync(MigrateRequest migrateRequest, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.migrateValidateBeforeCall(migrateRequest, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call recoverTablesCall(TablesRecoveryRequest tablesRecoveryRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TablesRecoveryRequest localVarPostBody = tablesRecoveryRequest;
        String localVarPath = "/management/v1/recovery/tables";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call recoverTablesValidateBeforeCall(TablesRecoveryRequest tablesRecoveryRequest, ApiCallback _callback) throws ApiException {
        if (tablesRecoveryRequest == null) {
            throw new ApiException("Missing the required parameter 'tablesRecoveryRequest' when calling recoverTables(Async)");
        }
        return this.recoverTablesCall(tablesRecoveryRequest, _callback);
    }

    public TablesRecoveryResponse recoverTables(TablesRecoveryRequest tablesRecoveryRequest) throws ApiException {
        ApiResponse<TablesRecoveryResponse> localVarResp = this.recoverTablesWithHttpInfo(tablesRecoveryRequest);
        return localVarResp.getData();
    }

    public ApiResponse<TablesRecoveryResponse> recoverTablesWithHttpInfo(TablesRecoveryRequest tablesRecoveryRequest) throws ApiException {
        Call localVarCall = this.recoverTablesValidateBeforeCall(tablesRecoveryRequest, null);
        Type localVarReturnType = new TypeToken<TablesRecoveryResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call recoverTablesAsync(TablesRecoveryRequest tablesRecoveryRequest, ApiCallback<TablesRecoveryResponse> _callback) throws ApiException {
        Call localVarCall = this.recoverTablesValidateBeforeCall(tablesRecoveryRequest, _callback);
        Type localVarReturnType = new TypeToken<TablesRecoveryResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call resetClusterCall(ResetClusterRequest resetClusterRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ResetClusterRequest localVarPostBody = resetClusterRequest;
        String localVarPath = "/management/v1/recovery/cluster/reset";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resetClusterValidateBeforeCall(ResetClusterRequest resetClusterRequest, ApiCallback _callback) throws ApiException {
        if (resetClusterRequest == null) {
            throw new ApiException("Missing the required parameter 'resetClusterRequest' when calling resetCluster(Async)");
        }
        return this.resetClusterCall(resetClusterRequest, _callback);
    }

    public void resetCluster(ResetClusterRequest resetClusterRequest) throws ApiException {
        this.resetClusterWithHttpInfo(resetClusterRequest);
    }

    public ApiResponse<Void> resetClusterWithHttpInfo(ResetClusterRequest resetClusterRequest) throws ApiException {
        Call localVarCall = this.resetClusterValidateBeforeCall(resetClusterRequest, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call resetClusterAsync(ResetClusterRequest resetClusterRequest, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.resetClusterValidateBeforeCall(resetClusterRequest, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call resetPartitionsCall(ResetPartitionsRequest resetPartitionsRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ResetPartitionsRequest localVarPostBody = resetPartitionsRequest;
        String localVarPath = "/management/v1/recovery/partitions/reset";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resetPartitionsValidateBeforeCall(ResetPartitionsRequest resetPartitionsRequest, ApiCallback _callback) throws ApiException {
        if (resetPartitionsRequest == null) {
            throw new ApiException("Missing the required parameter 'resetPartitionsRequest' when calling resetPartitions(Async)");
        }
        return this.resetPartitionsCall(resetPartitionsRequest, _callback);
    }

    public void resetPartitions(ResetPartitionsRequest resetPartitionsRequest) throws ApiException {
        this.resetPartitionsWithHttpInfo(resetPartitionsRequest);
    }

    public ApiResponse<Void> resetPartitionsWithHttpInfo(ResetPartitionsRequest resetPartitionsRequest) throws ApiException {
        Call localVarCall = this.resetPartitionsValidateBeforeCall(resetPartitionsRequest, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call resetPartitionsAsync(ResetPartitionsRequest resetPartitionsRequest, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.resetPartitionsValidateBeforeCall(resetPartitionsRequest, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call resetZonePartitionsCall(ResetZonePartitionsRequest resetZonePartitionsRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ResetZonePartitionsRequest localVarPostBody = resetZonePartitionsRequest;
        String localVarPath = "/management/v1/recovery/zone/partitions/reset";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resetZonePartitionsValidateBeforeCall(ResetZonePartitionsRequest resetZonePartitionsRequest, ApiCallback _callback) throws ApiException {
        if (resetZonePartitionsRequest == null) {
            throw new ApiException("Missing the required parameter 'resetZonePartitionsRequest' when calling resetZonePartitions(Async)");
        }
        return this.resetZonePartitionsCall(resetZonePartitionsRequest, _callback);
    }

    public void resetZonePartitions(ResetZonePartitionsRequest resetZonePartitionsRequest) throws ApiException {
        this.resetZonePartitionsWithHttpInfo(resetZonePartitionsRequest);
    }

    public ApiResponse<Void> resetZonePartitionsWithHttpInfo(ResetZonePartitionsRequest resetZonePartitionsRequest) throws ApiException {
        Call localVarCall = this.resetZonePartitionsValidateBeforeCall(resetZonePartitionsRequest, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call resetZonePartitionsAsync(ResetZonePartitionsRequest resetZonePartitionsRequest, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.resetZonePartitionsValidateBeforeCall(resetZonePartitionsRequest, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call restartPartitionsCall(RestartPartitionsRequest restartPartitionsRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RestartPartitionsRequest localVarPostBody = restartPartitionsRequest;
        String localVarPath = "/management/v1/recovery/partitions/restart";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call restartPartitionsValidateBeforeCall(RestartPartitionsRequest restartPartitionsRequest, ApiCallback _callback) throws ApiException {
        if (restartPartitionsRequest == null) {
            throw new ApiException("Missing the required parameter 'restartPartitionsRequest' when calling restartPartitions(Async)");
        }
        return this.restartPartitionsCall(restartPartitionsRequest, _callback);
    }

    public void restartPartitions(RestartPartitionsRequest restartPartitionsRequest) throws ApiException {
        this.restartPartitionsWithHttpInfo(restartPartitionsRequest);
    }

    public ApiResponse<Void> restartPartitionsWithHttpInfo(RestartPartitionsRequest restartPartitionsRequest) throws ApiException {
        Call localVarCall = this.restartPartitionsValidateBeforeCall(restartPartitionsRequest, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call restartPartitionsAsync(RestartPartitionsRequest restartPartitionsRequest, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.restartPartitionsValidateBeforeCall(restartPartitionsRequest, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call restartPartitionsWithCleanupCall(RestartPartitionsRequest restartPartitionsRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RestartPartitionsRequest localVarPostBody = restartPartitionsRequest;
        String localVarPath = "/management/v1/recovery/partitions/restartWithCleanup";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call restartPartitionsWithCleanupValidateBeforeCall(RestartPartitionsRequest restartPartitionsRequest, ApiCallback _callback) throws ApiException {
        if (restartPartitionsRequest == null) {
            throw new ApiException("Missing the required parameter 'restartPartitionsRequest' when calling restartPartitionsWithCleanup(Async)");
        }
        return this.restartPartitionsWithCleanupCall(restartPartitionsRequest, _callback);
    }

    public void restartPartitionsWithCleanup(RestartPartitionsRequest restartPartitionsRequest) throws ApiException {
        this.restartPartitionsWithCleanupWithHttpInfo(restartPartitionsRequest);
    }

    public ApiResponse<Void> restartPartitionsWithCleanupWithHttpInfo(RestartPartitionsRequest restartPartitionsRequest) throws ApiException {
        Call localVarCall = this.restartPartitionsWithCleanupValidateBeforeCall(restartPartitionsRequest, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call restartPartitionsWithCleanupAsync(RestartPartitionsRequest restartPartitionsRequest, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.restartPartitionsWithCleanupValidateBeforeCall(restartPartitionsRequest, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call restartZonePartitionsCall(RestartZonePartitionsRequest restartZonePartitionsRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RestartZonePartitionsRequest localVarPostBody = restartZonePartitionsRequest;
        String localVarPath = "/management/v1/recovery/zone/partitions/restart";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call restartZonePartitionsValidateBeforeCall(RestartZonePartitionsRequest restartZonePartitionsRequest, ApiCallback _callback) throws ApiException {
        if (restartZonePartitionsRequest == null) {
            throw new ApiException("Missing the required parameter 'restartZonePartitionsRequest' when calling restartZonePartitions(Async)");
        }
        return this.restartZonePartitionsCall(restartZonePartitionsRequest, _callback);
    }

    public void restartZonePartitions(RestartZonePartitionsRequest restartZonePartitionsRequest) throws ApiException {
        this.restartZonePartitionsWithHttpInfo(restartZonePartitionsRequest);
    }

    public ApiResponse<Void> restartZonePartitionsWithHttpInfo(RestartZonePartitionsRequest restartZonePartitionsRequest) throws ApiException {
        Call localVarCall = this.restartZonePartitionsValidateBeforeCall(restartZonePartitionsRequest, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call restartZonePartitionsAsync(RestartZonePartitionsRequest restartZonePartitionsRequest, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.restartZonePartitionsValidateBeforeCall(restartZonePartitionsRequest, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call restartZonePartitionsWithCleanupCall(RestartZonePartitionsRequest restartZonePartitionsRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RestartZonePartitionsRequest localVarPostBody = restartZonePartitionsRequest;
        String localVarPath = "/management/v1/recovery/zone/partitions/restartWithCleanup";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call restartZonePartitionsWithCleanupValidateBeforeCall(RestartZonePartitionsRequest restartZonePartitionsRequest, ApiCallback _callback) throws ApiException {
        if (restartZonePartitionsRequest == null) {
            throw new ApiException("Missing the required parameter 'restartZonePartitionsRequest' when calling restartZonePartitionsWithCleanup(Async)");
        }
        return this.restartZonePartitionsWithCleanupCall(restartZonePartitionsRequest, _callback);
    }

    public void restartZonePartitionsWithCleanup(RestartZonePartitionsRequest restartZonePartitionsRequest) throws ApiException {
        this.restartZonePartitionsWithCleanupWithHttpInfo(restartZonePartitionsRequest);
    }

    public ApiResponse<Void> restartZonePartitionsWithCleanupWithHttpInfo(RestartZonePartitionsRequest restartZonePartitionsRequest) throws ApiException {
        Call localVarCall = this.restartZonePartitionsWithCleanupValidateBeforeCall(restartZonePartitionsRequest, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call restartZonePartitionsWithCleanupAsync(RestartZonePartitionsRequest restartZonePartitionsRequest, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.restartZonePartitionsWithCleanupValidateBeforeCall(restartZonePartitionsRequest, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

