/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import java.util.Collection;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite3.raft.jraft.rpc.CliRequests;
import org.apache.ignite3.raft.jraft.rpc.ResetPeerRequestBuilder;

class ResetPeerRequestDeserializer
implements MessageDeserializer<CliRequests.ResetPeerRequest> {
    private final ResetPeerRequestBuilder msg;

    ResetPeerRequestDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.resetPeerRequest();
    }

    @Override
    public Class<CliRequests.ResetPeerRequest> klass() {
        return CliRequests.ResetPeerRequest.class;
    }

    @Override
    public CliRequests.ResetPeerRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(RaftMessagesTypeInfos.resetPeerRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                String tmp = reader.readString("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.groupId(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                String tmp = reader.readCollection("newPeersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.newPeersList((Collection<String>)((Object)tmp));
                }
                reader.incrementState();
            }
            case 2: {
                String tmp = reader.readCollection("oldPeersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.oldPeersList((Collection<String>)((Object)tmp));
                }
                reader.incrementState();
            }
            case 3: {
                String tmp = reader.readString("peerId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.peerId(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CliRequests.ResetPeerRequest.class);
    }
}

