/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.entity;

import java.util.Arrays;
import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.raft.jraft.entity.LocalFileMetaBuilder;
import org.apache.ignite3.raft.jraft.entity.LocalFileMetaOutter;
import org.apache.ignite3.raft.jraft.entity.LocalFileMetaSerializer;

public class LocalFileMetaImpl
implements LocalFileMetaOutter.LocalFileMeta,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 2002;
    @IgniteToStringInclude
    private final String checksum;
    @IgniteToStringInclude
    private final int sourceNumber;
    @IgniteToStringInclude
    private final byte[] userMeta;

    private LocalFileMetaImpl(String checksum, int sourceNumber, byte[] userMeta) {
        this.checksum = checksum;
        this.sourceNumber = sourceNumber;
        this.userMeta = userMeta;
    }

    @Override
    public String checksum() {
        return this.checksum;
    }

    @Override
    public int sourceNumber() {
        return this.sourceNumber;
    }

    @Override
    public byte[] userMeta() {
        return this.userMeta;
    }

    public MessageSerializer serializer() {
        return LocalFileMetaSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(LocalFileMetaImpl.class, this);
    }

    @Override
    public short messageType() {
        return 2002;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LocalFileMetaImpl otherMessage = (LocalFileMetaImpl)other;
        return Objects.equals(this.checksum, otherMessage.checksum) && Arrays.equals(this.userMeta, otherMessage.userMeta) && this.sourceNumber == otherMessage.sourceNumber;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.sourceNumber, this.checksum);
        result = 31 * result + Arrays.hashCode(this.userMeta);
        return result;
    }

    @Override
    public LocalFileMetaImpl clone() {
        try {
            return (LocalFileMetaImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static LocalFileMetaBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements LocalFileMetaBuilder {
        private String checksum;
        private int sourceNumber;
        private byte[] userMeta;

        private Builder() {
        }

        @Override
        public LocalFileMetaBuilder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        @Override
        public LocalFileMetaBuilder sourceNumber(int sourceNumber) {
            this.sourceNumber = sourceNumber;
            return this;
        }

        @Override
        public LocalFileMetaBuilder userMeta(byte[] userMeta) {
            this.userMeta = userMeta;
            return this;
        }

        @Override
        public String checksum() {
            return this.checksum;
        }

        @Override
        public int sourceNumber() {
            return this.sourceNumber;
        }

        @Override
        public byte[] userMeta() {
            return this.userMeta;
        }

        @Override
        public LocalFileMetaOutter.LocalFileMeta build() {
            return new LocalFileMetaImpl(this.checksum, this.sourceNumber, this.userMeta);
        }

        @Override
        public LocalFileMetaOutter.LocalFileMeta buildDeserialized() {
            return new LocalFileMetaImpl(this.checksum, this.sourceNumber, this.userMeta);
        }
    }
}

